package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfry.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfryRyksxxVo
 * @author chris
 * @description 执法人员的考试信息实体类
 * @version 1.0
 * @date 2021-03-30 19:11
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFRYGL_J_RYKSXX")
public class ZfryRyksxxVo extends BaseEntity<String> {
    /******
     * 人员考试信息Id
     */
    @TableId
    @TableField("RYKSXX_ID")
    private String ryksxxId;

    /******
     * 执法人员信息Id
     */
    @TableField("ZFRYXX_ID")
    private String zfryxxId;

    /******
     * 附加信息来源代码
     */
    @TableField("FJXXSJLYDM")
    private String fjxxsjlydm;

    /******
     * 考试类型代码
     */
    @TableField("KSLXDM")
    private String kslxdm;

    /******
     * 考试日期
     */
    @TableField("KSRQ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date ksrq;

    /******
     * 考试成绩
     */
    @TableField("KSCJ")
    private String kscj;

    /******
     * 考试机构名称
     */
    @TableField("KSJGMC")
    private String ksjgmc;

    /******
     * 考试结果:0-不通过,1-通过
     */
    @TableField("KSJG")
    private String ksjg;

    /******
     * 备注
     */
    @TableField("BZ")
    private String bz;

    /******
     * 考试类型代码Text
     */
    @TableField(exist = false)
    private String kslxdmText;

    /*****
     * 附加信息来源代码Text
     */
    @TableField(exist = false)
    private String fjxxsjlydmText;

    /*****
     * 考试结果Text:0-不通过,1-通过
     */
    @TableField(exist = false)
    private String ksjgText;

    @Override
    public String getId() {
        return ryksxxId;
    }

    @Override
    public void setId(String id) {
        this.ryksxxId = id;
    }
}
