package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfry.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfryRyjyxxVo
 * @author chris
 * @description 执法人员的教育信息实体类
 * @version 1.0
 * @date 2021-03-30 19:10
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFRYGL_J_ZFRYXX")
public class ZfryRyjyxxVo extends BaseEntity<String> {

    /******
     * 人员教育信息Id
     */
    @TableId
    @TableField("RYJYXX_ID")
    private String ryjyxxId;

    /******
     * 执法人员信息Id
     */
    @TableField("ZFRYXX_ID")
    private String zfryxxId;

    /******
     * 毕业日期
     */
    @TableField("BYRQ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date byrq;

    /******
     * 学历代码
     */
    @TableField("XLDM")
    private String xldm;

    /******
     * 毕业学校
     */
    @TableField("BYXX")
    private String byxx;

    /******
     * 毕业专业
     */
    @TableField("BYZY")
    private String byzy;

    /******
     * 附加信息来源代码
     */
    @TableField("FJXXSJLYDM")
    private String fjxxsjlydm;

    /******
     * 备注
     */
    @TableField("BZ")
    private String bz;

    /*****
     * 学历代码Text
     */
    @TableField(exist = false)
    private String xldmText;

    /*****
     * 附加信息来源代码Text
     */
    @TableField(exist = false)
    private String fjxxsjlydmText;

    @Override
    public String getId() {
        return ryjyxxId;
    }

    @Override
    public void setId(String id) {
        this.ryjyxxId = id;
    }
}
