package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfry.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfryRyjlxxVo
 * @author chris
 * @description 执法人员的人员奖励信息实体类
 * @version 1.0
 * @date 2021-03-30 19:10
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFRYGL_J_RYJLXX")
public class ZfryRyjlxxVo extends BaseEntity<String> {
    /******
     * 人员奖励信息Id
     */
    @TableId
    @TableField("RYJLXX_ID")
    private String ryjlxxId;

    /******
     * 执法人员信息Id
     */
    @TableField("ZFRYXX_ID")
    private String zfryxxId;

    /******
     * 附加信息来源代码
     */
    @TableField("FJXXSJLYDM")
    private String fjxxsjlydm;

    /******
     * 奖励类型代码
     */
    @TableField("JLLXDM")
    private String jllxdm;

    /******
     * 奖励日期
     */
    @TableField("JLRQ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date jlrq;

    /******
     * 奖励描述
     */
    @TableField("JLMS")
    private String jlms;

    /******
     * 备注
     */
    @TableField("BZ")
    private String bz;

    /*****
     * 附加信息来源代码Text
     */
    @TableField(exist = false)
    private String fjxxsjlydmText;

    /******
     * 奖励类型代码Text
     */
    @TableField(exist = false)
    private String jllxdmText;

    @Override
    public String getId() {
        return ryjlxxId;
    }

    @Override
    public void setId(String id) {
        this.ryjlxxId = id;
    }
}
