package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfry.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfryRycfxxVo
 * @author chris
 * @description 执法人员的人员惩罚信息实体类
 * @version 1.0
 * @date 2021-03-30 19:09
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFRYGL_J_RYCFXX")
public class ZfryRycfxxVo extends BaseEntity<String> {
    /******
     * 人员奖励信息Id
     */
    @TableId
    @TableField("RYCFXX_ID")
    private String rycfxxId;

    /******
     * 执法人员信息Id
     */
    @TableField("ZFRYXX_ID")
    private String zfryxxId;

    /******
     * 附加信息来源代码
     */
    @TableField("FJXXSJLYDM")
    private String fjxxsjlydm;

    /******
     * 惩罚类型代码
     */
    @TableField("cfLXDM")
    private String cflxdm;

    /******
     * 惩罚日期
     */
    @TableField("CFRQ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date cfrq;

    /******
     * 惩罚描述
     */
    @TableField("CFMS")
    private String cfms;

    /******
     * 备注
     */
    @TableField("BZ")
    private String bz;

    /*****
     * 附加信息来源代码Text
     */
    @TableField(exist = false)
    private String fjxxsjlydmText;

    /******
     * 惩罚类型代码Text
     */
    @TableField(exist = false)
    private String cflxdmText;

    @Override
    public String getId() {
        return rycfxxId;
    }

    @Override
    public void setId(String id) {
        this.rycfxxId = id;
    }
}
