package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfry.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfryRybdxxVo
 * @author chris
 * @description 执法人员的人员变动信息实体类
 * @version 1.0
 * @date 2021-03-30 19:09
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFRYGL_J_RYBDXX")
public class ZfryRybdxxVo extends BaseEntity<String> {

    /******
     * 执法人员变动信息Id
     */
    @TableId
    @TableField("RYBDXX_ID")
    private String rybdxxId;

    /******
     * 执法人员Id
     */
    @TableField("ZFRYXX_ID")
    private String zfryxxId;

    /******
     * 调动状态代码
     */
    @TableField("DDZTDM")
    private String ddztdm;

    /******
     * 执法门类代码(变动前)
     */
    @TableField("ZFMLDM_DDQ")
    private String zfmldmDdq;

    /******
     * 组织机构Id(变动前)
     */
    @TableField("ZZJGID_DDQ")
    private String zzjgidDdq;

    /******
     * 职务代码(变动前)
     */
    @TableField("ZWDM_DDQ")
    private String zwdmDdq;

    /******
     * 执法区域(变动前)
     */
    @TableField("DRQZFQY")
    private String drqzfqy;

    /******
     * 岗位代码(变动前)
     */
    @TableField("GWDM_DDQ")
    private String gwdmDdq;

    /******
     * 执法门类代码(变动后)
     */
    @TableField("ZFMLDM_DDH")
    private String zfmldmDdh;

    /******
     * 组织机构Id(变动后)
     */
    @TableField("ZZJGID_DDH")
    private String zzjgidDdh;

    /******
     * 职务代码(变动后)
     */
    @TableField("ZWDM_DDH")
    private String zwdmDdh;

    /******
     * 执法区域(变动后)
     */
    @TableField("DRHZFQY")
    private String drhzfqy;

    /******
     * 岗位代码(变动后)
     */
    @TableField("GWDM_DDH")
    private String gwdmDdh;

    /******
     * 变动类型代码
     */
    @TableField("BDLXDM")
    private String bdlxdm;

    /******
     * 调动原因
     */
    @TableField("DDYY")
    private String ddyy;

    /******
     * 申请时间
     */
    @TableField("SQSJ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date sqsj;

    /******
     * 变动时间
     */
    @TableField("BDSJ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date bdsj;

    /******
     * 拒绝原因
     */
    @TableField("JJYY")
    private String jjyy;

    /******
     * 信息修改状态
     */
    @TableField("XXXGZT")
    private String xxxgzt;

    /******
     * 调动操作人所属机构Id
     */
    @TableField("ZZJG_ID")
    private String zzjgId;

    /*****
     * 调动状态代码Text
     */
    @TableField(exist = false)
    private String ddztdmText;

    /*****
     * 执法门类代码Text(变动前)
     */
    @TableField(exist = false)
    private String zfmldmDdqText;

    /*****
     * 执法门类代码Text(变动后)
     */
    @TableField(exist = false)
    private String zfmldmDdhText;

    /*****
     * 职务代码Text(变动前)
     */
    @TableField(exist = false)
    private String zwdmDdqText;

    /*****
     * 职务代码Text(变动后)
     */
    @TableField(exist = false)
    private String zwdmDdhText;

    /*****
     * 岗位代码Text(变动前)
     */
    @TableField(exist = false)
    private String gwdmDdqText;

    /*****
     * 岗位代码Text(变动后)
     */
    @TableField(exist = false)
    private String gwdmDdhText;

    /*****
     * 组织机构名称(变动前)
     */
    @TableField(exist = false)
    private String zzjgDdqName;

    /*****
     * 组织机构名称(变动后)
     */
    @TableField(exist = false)
    private String zzjgDdhName;

    /*****
     * 执法人员姓名
     */
    @TableField(exist = false)
    private String xm;

    /*****
     * 执法证号
     */
    @TableField(exist = false)
    private String zfzh;

    /*****
     * 身份证号
     */
    @TableField(exist = false)
    private String sfzjhm;

    @Override
    public String getId() {
        return rybdxxId;
    }

    @Override
    public void setId(String id) {
        this.rybdxxId = id;
    }
}
