package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfry.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className ZfryKhxmVo
 * @author chris
 * @description 执法人员考核项目实体类
 * @version 1.0
 * @date 2021-03-25 16:22
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFRYGL_J_KHXM")
public class ZfryKhxmVo extends BaseEntity<String> {
    /****
     * 考核项目根节点Id
     */
    public static final String KHXM_ROOT_ID = "0";

    /*****
     * 考核项目Id
     */
    @TableField("KHXM_ID")
    private String khxmId;

    /*****
     * 组织机构Id(制定机构Id)
     */
    @TableField("ZZJGID")
    private String zzjgid;

    /*****
     * 考核项目种类代码
     */
    @TableField("KHXMZLDM")
    private String khxmzldm;

    /*****
     * 父级考核项目Id
     */
    @TableField("SJ_KHXM_ID")
    private String sjkhxmid;

    /*****
     * 考核层级
     */
    @TableField("CJ")
    private String cj;

    /*****
     * 考核标题
     */
    @TableField("KHBT")
    private String khbt;

    /*****
     * 考核内容
     */
    @TableField("KHNR")
    private String khnr;

    /*****
     * 检查方法
     */
    @TableField("JCFF")
    private String jcff;

    /*****
     * 评分标准
     */
    @TableField("PFBZ")
    private String pfbz;

    /*****
     * 标准分值
     */
    @TableField("BZFZ")
    private String bzfz;

    /*****
     * 状态
     */
    @TableField("SFQY")
    private String sfqy;

    /*******
     * 组织机构名称(制定机构名称)
     */
    @TableField(exist = false)
    private String zzjgName;

    /*******
     * 父级考核标题
     */
    @TableField(exist = false)
    private String sjkhxmbt;

    /*******
     * 父级考核内容
     */
    @TableField(exist = false)
    private String sjkhxmnr;

    /*******
     * 考核项目种类代码Text
     */
    @TableField(exist = false)
    private String khxmzldmText;

    /*******
     * 考核层级Text
     */
    @TableField(exist = false)
    private String cjText;

    /*******
     * 状态Text
     */
    @TableField(exist = false)
    private String sfqyText;

    @Override
    public String getId() {
        return khxmId;
    }

    @Override
    public void setId(String id) {
        this.khxmId = id;
    }
}
