package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfry.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfryKhjlbVo
 * @author chris
 * @description 执法人员考核记录表实体类
 * @version 1.0
 * @date 2021-03-31 20:37
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFRYGL_J_KHJLB")
public class ZfryKhjlbVo extends BaseEntity<String> {

    /******
     * 执法人员考核记录表信息Id
     */
    @TableId
    @TableField("KHJLB_ID")
    private String khjlbId;

    /******
     * 执法人员考信息Id
     */
    @TableField("ZFRYXX_ID")
    private String zfryxxId;

    /******
     * 考核标准Id
     */
    @TableField("KHBZ_ID")
    private String khbzId;

    /******
     * 考核标准版本号
     */
    @TableField("BBH")
    private String bbh;

    /******
     * 考核年度
     */
    @TableField("KHND")
    private String khnd;

    /******
     * 考核时间
     */
    @TableField("KHSJ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date khsj;

    /******
     * 总分
     */
    @TableField("ZF")
    private String zf;

    /******
     * 考核得分
     */
    @TableField("KHDF")
    private String khdf;

    /******
     * 考核结果
     */
    @TableField("KHJG")
    private String khjg;

    /******
     * 被考核人意见
     */
    @TableField("BKHRYJ")
    private String bkhryj;

    /******
     * 被考核人签字日期
     */
    @TableField("BKHRQZRQ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date bkhrqzrq;

    /******
     * 考核人签字
     */
    @TableField("KHRQZ")
    private String khrqz;

    /******
     * 考核人签字日期
     */
    @TableField("KHRQZRQ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date khrqzrq;

    /******
     * 考核人员
     */
    @TableField("KHRY")
    private String khry;

    /******
     * 考核单位Id
     */
    @TableField("KHDW_ID")
    private String khdwId;

    /******
     * 考核单位名称
     */
    @TableField("KHDWMC")
    private String khdwmc;

    /******
     * 被考核人员单位Id
     */
    @TableField("BKHRYDW_ID")
    private String bkhrydwId;

    /******
     * 被考核人员单位名称
     */
    @TableField("BKHRYDWMC")
    private String bkhrydwmc;

    /*****
     * 执法人员姓名
     */
    @TableField(exist = false)
    private String xm;

    /*****
     * 执法证号
     */
    @TableField(exist = false)
    private String zfzh;

    /*****
     * 身份证号
     */
    @TableField(exist = false)
    private String sfzjhm;

    /******
     * 组织机构Id
     */
    private String zzjgid;

    /*****
     * 组织机构名称
     */
    @TableField(exist = false)
    private String zzjgName;

    /*****
     * 证件状态代码
     */
    @TableField(exist = false)
    private String zjztdm;

    /*****
     * 证件状态代码Text
     */
    @TableField(exist = false)
    private String zjztdmText;

    /*****
     * 性别代码
     */
    @TableField(exist = false)
    private String xbdm;

    /*****
     * 性别代码Text
     */
    @TableField(exist = false)
    private String xbdmText;

    /*****
     * 职务代码
     */
    @TableField(exist = false)
    private String zwdm;

    /*****
     * 职务代码Text
     */
    @TableField(exist = false)
    private String zwdmText;

    /*****
     * 执法门类代码
     */
    @TableField(exist = false)
    private String zfmldm;

    /*****
     * 执法门类代码Text
     */
    @TableField(exist = false)
    private String zfmldmText;

    /*****
     * 是否考核代码
     */
    @TableField(exist = false)
    private String sfkh;

    /*****
     * 是否考核代码Text
     */
    @TableField(exist = false)
    private String sfkhText;

    /*****
     * 考核结果代码Text
     */
    @TableField(exist = false)
    private String khjgText;

    @Override
    public String getId() {
        return khjlbId;
    }

    @Override
    public void setId(String id) {
        this.khjlbId = id;
    }
}
