package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfry.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfryKhbzVo
 * @author chris
 * @description 执法人员考核标准实体类
 * @version 1.0
 * @date 2021-03-30 19:08
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFRYGL_J_KHBZ")
public class ZfryKhbzVo extends BaseEntity<String> {

    /*****
     * 考核标准Id
     */
    @TableField("KHBZ_ID")
    private String khbzId;

    /*****
     * 考核标准版本号
     */
    @TableField("BBH")
    private String bbh;

    /*****
     * 标准分类代码
     */
    @TableField("BZFLDM")
    private String bzfldm;

    /*****
     * 组织机构Id
     */
    @TableField("ZZJGID")
    private String zzjgid;

    /*****
     * 考核年度
     */
    @TableField("KHND")
    private String khnd;

    /*****
     * 考核标准名称
     */
    @TableField("BZMC")
    private String bzmc;

    /*****
     * 状态
     */
    @TableField("ZT")
    private String zt;

    /*****
     * 启用日期
     */
    @TableField("QYRQ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date qyrq;

    /*****
     * 禁用日期
     */
    @TableField("JYRQ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date jyrq;

    /*****
     * 标准分类代码Text
     */
    @TableField(exist = false)
    private String bzfldmText;

    /*****
     * 状态Text
     */
    @TableField(exist = false)
    private String ztText;

    /*****
     * 组织机构名称
     */
    @TableField(exist = false)
    private String zzjgName;

    @Override
    public String getId() {
        return khbzId;
    }

    @Override
    public void setId(String id) {
        this.khbzId = id;
    }
}
