package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfpx.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfpxKjxxVo
 * @author chris
 * @description 执法培训课件信息实体类
 * @version 1.0
 * @date 2021-03-30 20:22
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFPXGL_J_KJXX")
public class ZfpxKjxxVo  extends BaseEntity<String> {

    /*****
     * 课件信息Id
     */
    @TableId
    @TableField("KJXX_ID")
    private String kjxxId;

   /*****
     * 课件类型代码
     */
    @TableField("KJLXDM")
    private String kjlxdm;

   /*****
     * 课件简介
     */
    @TableField("KJJJ")
    private String kjjj;

   /*****
     * 课件名称
     */
    @TableField("KJMC")
    private String kjmc;

   /*****
     * 课件状态
     */
    @TableField("KJZT")
    private String kjzt;

   /*****
     * 阅读方式
     */
    @TableField("YDFS")
    private String ydfs;

   /*****
     * 课件大小
     */
    @TableField("KJDX")
    private String kjdx;

   /*****
     * 法律法规类别代码
     */
    @TableField("FLFGLBDM")
    private String flfglbdm;

   /*****
     * 组织机构Id
     */
    @TableField("ZZJGID")
    private String zzjgid;

   /*****
     * 学时
     */
    @TableField("XS")
    private String xs;

   /*****
     * 学分
     */
    @TableField("XF")
    private String xf;

   /*****
     * 发布日期
     */
    @TableField("FBRQ")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date fbrq;

   /*****
     * 禁用日期
     */
    @TableField("JYRQ")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date jyrq;

    /*****
     * 课件类型代码Text
     */
    @TableField(exist = false)
    private String kjlxdmText;

    /*****
     * 课件状态Text
     */
    @TableField(exist = false)
    private String kjztText;

    /*****
     * 阅读方式Text
     */
    @TableField(exist = false)
    private String ydfsText;

    /*****
     * 法律法规类别代码Text
     */
    @TableField(exist = false)
    private String flfglbdmText;

    @Override
    public String getId() {
        return kjxxId;
    }

    @Override
    public void setId(String id) {
        this.kjxxId = id;
    }
}
