package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfpx.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfpxKcplxxVo
 * @author chris
 * @description 执法培训课程评论信息实体类
 * @version 1.0
 * @date 2021-03-30 20:20
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFPXGL_J_KCPLXX")
public class ZfpxKcplxxVo extends BaseEntity<String> {
    /*****
     * 课程评论信息Id
     */
    @TableId
    @TableField("KCPLXX_ID")
    private String kcplxxId;

    /*****
     * 课程信息Id
     */
    @TableField("KCXX_ID")
    private String kcxxId;

    /*****
     * 执法人员信息Id
     */
    @TableField("ZFRYXX_ID")
    private String zfryxxId;

    /*****
     * 执法人员姓名
     */
    @TableField("XM")
    private String xm;

    /*****
     * 执法证号
     */
    @TableField("ZFZH")
    private String zfzh;

    /*****
     * 所属单位Id
     */
    @TableField("SSDWID")
    private String ssdwid;

    /*****
     * 所属单位名称
     */
    @TableField("SSDW")
    private String ssdw;

    /*****
     * 评论内容
     */
    @TableField("PLNR")
    private String plnr;

    /******
     * 评论时间
     */
    @TableField("PLSJ")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date plsj;

    @Override
    public String getId() {
        return kcxxId;
    }

    @Override
    public void setId(String id) {
        this.kcxxId = id;
    }
}
