package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfpx.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfpxKcdjjlVo
 * @author chris
 * @description 执法培训课程点击记录实体类
 * @version 1.0
 * @date 2021-03-30 20:20
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFPXGL_J_KCDJJL")
public class ZfpxKcdjjlVo extends BaseEntity<String> {
    /*****
     * 课程点击记录Id
     */
    @TableId
    @TableField("KCDJJL_ID")
    private String kcdjjlId;

    /*****
     * 课程信息Id
     */
    @TableField("KCXX_ID")
    private String kcxxId;

    /*****
     * 执法人员信息Id
     */
    @TableField("ZFRYXX_ID")
    private String zfryxxId;

    /*****
     * 执法人员姓名
     */
    @TableField("XM")
    private String xm;

    /*****
     * 组织机构Id
     */
    @TableField("ZZJGID")
    private String zzjgid;

    /*****
     * 所属机构名称
     */
    @TableField("SSJG")
    private String ssjg;

    /*****
     * 邮政编码
     */
    @TableField("YZBM")
    private String yzbm;

    /******
     * 点击时间
     */
    @TableField("DJSJ")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date djsj;

    @Override
    public String getId() {
        return kcdjjlId;
    }

    @Override
    public void setId(String id) {
        this.kcdjjlId = id;
    }
}
