package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfks.service;

import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.component.zfks.entity.tklx.TklxStlxVo;

import java.util.List;

/****
 * @className ZfksZfryStGlService
 * @author ChrisYolanda
 * @description 执法考试执法人员试题关联服务层接口
 * @version 1.0
 * @date 2021-01-31 08:37
 */
public interface ZfksZfryStGlService {

    /********
     * 执法考试执法人员试题列表信息
     * @param zfryId 执法人员Id
     * @param type 显示数据的类型:01-显示错题数据,02-显示标记数据
     * @return
     */
    List<TklxStlxVo> listData(String zfryId, String type);

    /********
     * 创建或更新标识
     * @param zfryId 执法人员Id
     * @param stId 试题Id
     * @param type 标志类型:01-错题本标识,02-标记本标识
     * @param user 当前登录用户
     */
    void saveOrUpdateSign(String zfryId, String stId, String type, SysUser user);

    /********
     * 更新执法考试执法人员试题关联信息是否过关标识
     * @param zfryId 执法人员Id
     * @param kstkId 考试题库Id
     * @param ggbs 过关标识
     * @param user 当前登录用户
     */
    void updateZfryStGlInfoSfggByZfryId(String zfryId,String kstkId ,String ggbs, SysUser user);

    /********
     * 更新执法考试执法人员试题关联信息是否过关标识
     * @param zfryId 执法人员Id
     * @param stId 试题Id
     * @param ggbs 过关标识
     * @param user 当前登录用户
     */
    void saveOrUpdateZfryStGlInfoSfggByZfryIdAndStId(String zfryId, String stId, String ggbs, SysUser user);

    /********
     * 创建或修改执法考试执法人员试题关联信息的错题标识
     * @param zfryId 执法人员Id
     * @param stId 试题Id
     * @param ctbz 错题标识
     * @param user 当前登录用户
     */
    void saveOrUpdateZfryStGlInfoCtbzByZfryIdAndStId(String zfryId, String stId, String ctbz, SysUser user);

    /********
     * 创建或修改执法考试执法人员试题关联信息的标记标识
     * @param zfryId 执法人员Id
     * @param stId 试题Id
     * @param bjbz 标记标识
     * @param user 当前登录用户
     */
    void saveOrUpdateZfryStGlInfoBjbzByZfryIdAndStId(String zfryId, String stId, String bjbz, SysUser user);
}
