package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfks.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.TreeDataVo;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.component.zfks.entity.zcjj.ZcSjtjVo;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.component.zfks.entity.zxcs.ZxcsSjVo;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.component.zfks.entity.zxks.ZxksSjVo;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.zfks.entity.ZfksKsxxVo;

import java.util.Date;
import java.util.List;

/****
 * @className KsXxService
 * @author ChrisYolanda
 * @description 考试信息服务层接口
 * @version 1.0
 * @date 2021-01-08 09:26
 */
public interface ZfksKsxxService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param zfryId 执法人员Id
     * @return
     */
    Page<ZfksKsxxVo> page(Page<ZfksKsxxVo> page, ZfksKsxxVo entity, String zfryId);

    /*******
     * 查看考试试卷信息(包括在线考试和在线测试)
     * @param zfryId 执法人员信息Id
     * @param ksxxId 考试信息Id
     * @param curTime 当前系统时间
     * @return
     */
    ZxksSjVo getZfksKsxxDetailInfoByZfryIdAndKsxxId(String zfryId, String ksxxId, Date curTime);

    /******
     * 执法考试自测试卷提交
     * @param entity 试卷提交信息
     */
    void zfksZcSjtj(ZcSjtjVo entity);

    /******
     * 获取在线测试试卷信息
     * @param zfryId 执法人员信息Id
     * @param ksxxId 考试信息Id
     * @return
     */
    ZxcsSjVo getZxCsSjInfo(String zfryId, String ksxxId);

    /*******
     * 获取执法考试题库范围信息
     * @param ksxxId 考试信息Id
     * @return
     */
    List<TreeDataVo> getZfksKsxxTkfwInfoByKsxxId(String ksxxId);

    /*****
     * 加载所有的考试信息
     * @return
     */
    List<ZfksKsxxVo> queryAllKsxxInfo();

    /*****
     * 获取当天有效的考试信息
     * @return
     */
    List<ZfksKsxxVo> queryEffectKsxxDataList();

    /*****
     * 获取考试信息
     * @param ksxxId 考试信息Id
     * @return
     */
    ZfksKsxxVo getEntityInfoByKsxxId(String ksxxId);



}
