package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfks.service;

import com.kdgcsoft.jt.xzzf.dubbo.zfry.component.zfks.entity.kssj.SjstLbVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.component.zfks.entity.ksjj.KsSjstTjVo;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.zfks.entity.ZfksKsRySjStGlVo;

import java.util.List;

/****
 * @className ZfksKsRySjStGlService
 * @author ChrisYolanda
 * @description 执法考试考试人员试卷试题关联服务层接口
 * @version 1.0
 * @date 2021-01-21 14:44
 */
public interface ZfksKsRySjStGlService {

    /******
     * 保存或修改考试人员试卷试题关联信息
     * @param entity 试人员试卷试题关联实体类
     * @param sjstTjListInfo 试卷提交信息List
     * @param curUser 当前登录用户
     */
    void saveOrUpdate(ZfksKsRySjStGlVo entity, List<KsSjstTjVo> sjstTjListInfo, SysUser curUser);

    /******
     * 获取已参加考试的的执法人员试卷试题信息
     * @param sjId 试卷Id
     * @param zfryId 执法人员Id
     * @param ksxxId 考试信息Id
     * @return
     */
    List<SjstLbVo> getHasJoinExamZfrySjStInfoBySjIdAndZfryIdAndKsxxId(String sjId, String zfryId, String ksxxId);

    /******
     * 计算执法人员考试成绩
     * @param sjId 试卷Id
     * @param zfryId 执法人员Id
     * @param ksxxId 考试信息Id
     * @param curUser 当前登录用户
     * @return
     */
    void calZfryKscjInfoBySjIdAndZfryIdAndKsxxId(String sjId, String zfryId, String ksxxId, SysUser curUser);

    /******
     * 获取执法人员考试成绩信息
     * @param sjId 试卷Id
     * @param zfryId 执法人员Id
     * @param ksxxId 考试信息Id
     * @return
     */
    String getZfryKscjInfoBySjIdAndZfryIdAndKsxxId(String sjId, String zfryId, String ksxxId);

    /*******
     * 校验执法人员是否加入过考试并进行了交卷
     * @param zfryId 执法人员Id
     * @param ksxxId 考试信息Id
     * @return
     */
    Boolean verifyZfryHasJoinExamByZfryIdAndKsxxId(String zfryId, String ksxxId);
}
