package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfks.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.zfks.entity.ZfksKsRyGlVo;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.zfks.entity.ZfksKsxxVo;

import java.util.List;

/****
 * @className ZfksKsRyGlService
 * @author ChrisYolanda
 * @description 执法考试考试人员关联服务层接口
 * @version 1.0
 * @date 2021-01-21 14:43
 */
public interface ZfksKsRyGlService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @return
     */
    Page<ZfksKsRyGlVo> page(Page<ZfksKsRyGlVo> page, ZfksKsRyGlVo entity);

    /******
     * 保存或修改考试人员关联信息
     * @param entity 考试人员关联关系实体类
     * @param curUser 当前登录用户
     */
    void saveOrUpdate(ZfksKsRyGlVo entity, SysUser curUser);

    /******
     * 获取执法人员考试关联信息
     * @param zfryId 执法人员Id
     * @param ksxxId 考试信息Id
     * @return
     */
    ZfksKsRyGlVo getZfksKsRyGlInfoByZfryIdAndKsxxId(String zfryId, String ksxxId);

    /*****
     * 获取执法人员考试关联信息
     * @param id 主键ID
     * @return
     */
    ZfksKsRyGlVo getEntityInfoById(String id);

    /******
     * 更新执法人员考试成绩信息
     * @param entity 考试信息
     * @param sjId 试卷Id
     * @param zfryId 执法人员Id
     * @param ksxxId 考试信息Id
     * @param hgfs 合格分数
     * @param xfxx 学分信息
     * @param curUser 当前登录用户
     */
    void updateZfksKsRyGlKscjInfoBySjIdAndZfryIdAndKsxxId(ZfksKsxxVo entity, String sjId, String zfryId, String ksxxId, String hgfs, String xfxx, SysUser curUser);

    /*****
     * 导出查询
     * @param entity 实体类
     * @param zfryIds 执法人员主键集合
     * @param ksxxIds 考试信息主键集合
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    List<ZfksKsRyGlVo> export(ZfksKsRyGlVo entity, String zfryIds, String ksxxIds, String curUserOrgId);

    /*******
     * 获取所有的执法人员考试关联信息
     * @return
     */
    List<ZfksKsRyGlVo> getAllZfksKsRyGlInfo();

    /*******
     * 获取执法人员考试关联信息
     * @param ksxxId 考试信息Id
     * @return
     */
    List<ZfksKsRyGlVo> getZfksKsRyGlInfoByKsxxId(String ksxxId);

    /*****
     * 返回计算成绩结果
     * @param ksxxId 考试信息Id
     * @param zfryxxId 执法人员信息Id
     * @return
     */
    ZfksKsRyGlVo queryKsjg(String ksxxId, String zfryxxId);
}
