package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfks.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className ZfksZfryStGlVo
 * @author ChrisYolanda
 * @description 执法考试执法人员试题关联实体类
 * @version 1.0
 * @date 2021-01-31 08:31
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFKSGL_J_ZFRY_ST_GL")
public class ZfksZfryStGlVo extends BaseEntity<String> {

    /******
     * 执法考试执法人员试题关联标记类型
     * 01-错题本标识
     * 02-标记本标志
     * 03-过关标志
     */
    public static final String ZFKS_ZFRY_ST_GL_SIGN_TYPE_01 = "01";
    public static final String ZFKS_ZFRY_ST_GL_SIGN_TYPE_02 = "02";
    public static final String ZFKS_ZFRY_ST_GL_SIGN_TYPE_03 = "03";

    /*****
     * 执法考试执法人员试题关联信息Id
     */
    @TableId
    @TableField(exist = false)
    private String zfksZfryStGlId;

    /*****
     * 执法人员信息Id
     */
    @TableField("ZFRYXX_ID")
    private String zfryxxId;

    /*****
     * 试题Id
     */
    @TableField("ST_ID")
    private String stId;

    /*****
     * 考试题库Id
     */
    @TableField("KSTK_ID")
    private String kstkId;

    /*****
     * 是否过关
     * 0-未过关
     * 1-已过关
     */
    @TableField("SFGG")
    private String sfgg;

    /*****
     * 错题标志
     * 0-未标记
     * 1-已标记
     */
    @TableField("CTBZ")
    private String ctbz;

    /*****
     * 标记标志
     * 0-未标记
     * 1-已标记
     */
    @TableField("BJBZ")
    private String bjbz;

    /*****
     * 是否过关Text
     * 0-未过关
     * 1-已过关
     */
    @TableField(exist = false)
    private String sfggText;

    /*****
     * 错题标志Text
     * 0-未标记
     * 1-已标记
     */
    @TableField(exist = false)
    private String ctbzText;

    /*****
     * 标记标志Text
     * 0-未标记
     * 1-已标记
     */
    @TableField(exist = false)
    private String bjbzText;

    @Override
    public String getId() {
        return zfksZfryStGlId;
    }

    @Override
    public void setId(String id) {
        this.zfksZfryStGlId = id;
    }
}
