package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfks.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfksZcjlVo
 * @author chris
 * @description 执法考试自测记录实体类
 * @version 1.0
 * @date 2021-04-03 14:15
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFKSGL_J_ZCJL")
public class ZfksZcjlVo extends BaseEntity<String> {

    /****
     * 自测记录Id
     */
    @TableId
    @TableField("ZCJL_ID")
    private String zcjlId;

    /****
     * 执法人员信息Id
     */
    @TableField("ZFRYXX_ID")
    private String zfryxxId;

    /****
     * 测验时长(单位:秒)
     */
    @TableField("CYSC")
    private String cysc;

    /****
     * 实际测验时长(单位:秒)
     */
    @TableField("SJSYSC")
    private String sjsysc;

    /****
     * 题库类型范围
     */
    @TableField("TKLXFW")
    private String tklxfw;

    /****
     * 自测日期
     */
    @TableField("ZCRQ")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date zcrq;

    /****
     * 总分
     */
    @TableField("ZF")
    private String zf;

    /****
     * 得分
     */
    @TableField("DF")
    private String df;

    /****
     * 类型
     */
    @TableField("LX")
    private String lx;

    /****
     * 类型Text
     */
    @TableField(exist = false)
    private String lxText;


    @Override
    public String getId() {
        return zcjlId;
    }

    @Override
    public void setId(String id) {
        this.zcjlId = id;
    }
}
