package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfks.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className ZfksZcjlStGlVo
 * @author chris
 * @description 执法考试自测记录试题关联实体类
 * @version 1.0
 * @date 2021-04-03 14:17
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFKSGL_J_ZCJL_ST_GL")
public class ZfksZcjlStGlVo extends BaseEntity<String> {

    /****
     * 自测记录试题关联信息Id
     */
    @TableId
    @TableField(exist = false)
    private String zcjlStGlId;

    /****
     * 自测记录Id
     */
    @TableId
    @TableField("ZCJL_ID")
    private String zcjlId;

    /****
     * 试题Id
     */
    @TableField("ST_ID")
    private String stId;

    /****
     * 考试题库Id
     */
    @TableField("KSTK_ID")
    private String kstkId;

    /****
     * 自测节段Id
     */
    @TableField("ZCJD_ID")
    private String zcjdId;

    /****
     * 试题题型代码
     */
    @TableField("STTXDM")
    private String sttxdm;

    /****
     * 内容
     */
    @TableField("NR")
    private String nr;

    /****
     * 答案
     */
    @TableField("DA")
    private String da;

    /****
     * 排序
     */
    @TableField("PX")
    private String px;

    /****
     * 填写答案
     */
    @TableField("TXDA")
    private String txda;

    /****
     * 填写对错
     */
    @TableField("TXDC")
    private String txdc;

    /****
     * 主观题得分
     */
    @TableField("ZGTDF")
    private String zgtdf;

    /****
     * 试题题型代码Text
     */
    @TableField(exist = false)
    private String sttxdmText;

    @Override
    public String getId() {
        return zcjlStGlId;
    }

    @Override
    public void setId(String id) {
        this.zcjlStGlId = id;
    }
}
