package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfks.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfksStjctxVo
 * @author chris
 * @description 执法考试试题纠错提醒实体类
 * @version 1.0
 * @date 2021-04-03 13:50
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFKSGL_J_STJCTX")
public class ZfksStjctxVo extends BaseEntity<String> {

    /*****
     * 试题纠错提醒Id
     */
    @TableId
    @TableField("STJCTX_ID")
    private String stjctxId;

    /*****
     * 提醒人Id
     */
    @TableField("ZFRYXX_TX_ID")
    private String zfryxxTxId;

    /*****
     * 提醒人姓名
     */
    @TableField("TXRXM")
    private String txrxm;

    /*****
     * 处理人员Id
     */
    @TableField("ZFRYXX_CL_ID")
    private String zfryxxClId;

    /*****
     * 处理人名称
     */
    @TableField("CLRXM")
    private String clrxm;

    /*****
     * 试题Id
     */
    @TableField("ST_ID")
    private String stId;

    /*****
     * 提醒内容
     */
    @TableField("TXNR")
    private String txnr;

    /*****
     * 提醒时间
     */
    @TableField("TXSJ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date txsj;

    /*****
     * 处理结果
     */
    @TableField("CLJG")
    private String cljg;

    /*****
     * 处理时间
     */
    @TableField("clsj")
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date CLSJ;

    @Override
    public String getId() {
        return stjctxId;
    }

    @Override
    public void setId(String id) {
        this.stjctxId = id;
    }
}
