package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfks.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className ZfksStVo
 * @author ChrisYolanda
 * @description 执法考试试题实体类
 * @version 1.0
 * @date 2021-01-30 16:56
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFKSGL_J_ST")
public class ZfksStVo extends BaseEntity<String> {

    /****
     * 试题Id
     */
    @TableId
    @TableField("ST_ID")
    private String stId;

    /******
     * 试题难度代码
     */
    @TableField("STNDDM")
    private String stnddm;

    /******
     * 执法门类代码
     */
    @TableField("ZFMLDM")
    private String zfmldm;

    /******
     * 考试题库Id
     */
    @TableField("KSTK_ID")
    private String kstkId;

    /******
     * 试题题型代码
     */
    @TableField("STTXDM")
    private String sttxdm;

    /******
     * 试题编号
     */
    @TableField("BH")
    private String bh;

    /******
     * 试题内容
     */
    @TableField("NR")
    private String nr;

    /******
     * 试题答案
     */
    @TableField("DA")
    private String da;

    /******
     * 试题状态
     * 0-禁用
     * 1-启用
     */
    @TableField("ZT")
    private String zt;

    /******
     * 组卷次数
     */
    @TableField("ZJCS")
    private String zjcs;

    /******
     * 纠错提醒状态
     * 0-未处理
     * 1-已处理
     */
    @TableField("JCTXCLZT")
    private String jctxclzt;

    /******
     * 试题解析
     */
    @TableField("JX")
    private String jx;

    /******
     * 是否公开类型
     * 0-不公开
     * 1-公开
     */
    @TableField("SFGKLX")
    private String sfgklx;

    /******
     * 试题难度代码Text
     */
    @TableField(exist = false)
    private String stnddmText;

    /******
     * 执法门类代码Text
     */
    @TableField(exist = false)
    private String zfmldmText;

    /******
     * 试题题型代码Text
     * 0-未处理
     * 1-已处理
     */
    @TableField(exist = false)
    private String sttxdmText;

    /******
     * 试题状态Text
     * 0-禁用
     * 1-启用
     */
    @TableField(exist = false)
    private String ztText;

    /******
     * 纠错提醒状态Text
     */
    @TableField(exist = false)
    private String jctxclztText;

    /******
     * 是否公开类型Text
     * 0-不公开
     * 1-公开
     */
    @TableField(exist = false)
    private String sfgklxText;

    /******
     * 试题导入模板id
     */
    @TableField("DOC_ID")
    private String docId;

    /******
     * 试题导入模板名称
     */
    @TableField("mc")
    private String mc;

    /******
     * 试题导入模板序号
     */
    @TableField("sx")
    private String sx;

    @Override
    public String getId() {
        return stId;
    }

    @Override
    public void setId(String id) {
        this.stId = id;
    }
}
