package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfks.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfksSjmbVo
 * @author chris
 * @description 执法考试试卷模板实体类
 * @version 1.0
 * @date 2021-04-03 13:48
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFKSGL_J_SJMB")
public class ZfksSjmbVo extends BaseEntity<String> {

    /*****
     * 试卷模板Id
     */
    @TableId
    @TableField("SJMB_ID")
    private String sjmbId;

    /*****
     * 版本号
     */
    @TableField("BBH")
    private String bbh;

    /*****
     * 组织机构ID
     */
    @TableField("ZZJGID")
    private String zzjgid;

    /*****
     * 模板名称
     */
    @TableField("MBMC")
    private String mbmc;

    /*****
     * 状态
     */
    @TableField("ZT")
    private String zt;

    /*****
     * 总分
     */
    @TableField("ZF")
    private String zf;

    /*****
     * 执法门类
     */
    @TableField("ZFML")
    private String zfml;

    /*****
     * 启用日期
     */
    @TableField("QYRQ")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date qyrq;

    /*****
     * 考试方式
     */
    @TableField("KSFS")
    private String ksfs;

    /*****
     * 考试方式Text
     */
    @TableField(exist = false)
    private String ksfsText;

    /*****
     * 状态Text
     */
    @TableField(exist = false)
    private String ztText;

    /*****
     * 组织机构名称
     */
    @TableField(exist = false)
    private String zzjgName;

    @Override
    public String getId() {
        return sjmbId;
    }

    @Override
    public void setId(String id) {
        this.sjmbId = id;
    }

}
