package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfks.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfksSjVo
 * @author ChrisYolanda
 * @description 执法考试试卷实体类
 * @version 1.0
 * @date 2021-01-08 16:37
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFKSGL_J_SJ")
public class ZfksSjVo extends BaseEntity<String> {

    /****
     * 试卷Id
     */
    @TableId
    @TableField("SJ_ID")
    private String sjId;

    /******
     * 组卷方式代码
     */
    @TableField("ZJFSDM")
    private String zjfsdm;

    /******
     * 试卷模板Id
     */
    @TableField("SJMB_ID")
    private String sjmbId;

    /******
     * 版本号
     */
    @TableField("BBH")
    private String bbh;

    /******
     * 名称
     */
    @TableField("MC")
    private String mc;

    /******
     * 总分
     */
    @TableField("ZF")
    private String zf;

    /******
     * 时长,单位:分钟
     */
    @TableField("SC")
    private String sc;

    /******
     * 状态
     * 0-未报送
     * 1-待审核
     * 2-审核通过
     * 3-已下发
     * 9-审核不通过
     */
    @TableField("ZT")
    private String zt;

    /******
     * 简介
     */
    @TableField("JJ")
    private String jj;

    /******
     * 执法门类代码，多个以逗号隔开
     */
    @TableField("ZFML")
    private String zfml;

    /******
     * 下发日期
     */
    @TableField("XFRQ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date xfrq;

    /******
     * 审核意见
     */
    @TableField("SHYJ")
    private String shyj;

    /******
     * 审核人ID
     */
    @TableField("SHRID")
    private String shrid;

    /******
     * 审核人姓名
     */
    @TableField("SHRXM")
    private String shrxm;

    /******
     * 使用用途：
     * 1-日常
     * 2-评议考核
     */
    @TableField("SYYT")
    private String syyt;

    /******
     * 组织机构ID
     */
    @TableField("ZZJGID")
    private String zzjgid;

    @Override
    public String getId() {
        return sjId;
    }

    @Override
    public void setId(String id) {
        this.sjId = id;
    }
}
