package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfks.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.math.BigDecimal;

/****
 * @className ZfksMbJdVo
 * @author ChrisYolanda
 * @description 执法考试模板节段实体类
 * @version 1.0
 * @date 2021-02-02 16:51
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFKSGL_J_MBJD")
public class ZfksMbJdVo extends BaseEntity<String> {

    /*****
     * 模板节段信息Id
     */
    @TableId
    @TableField("MBJD_ID")
    private String mbjdId;

    /*****
     * 试卷模板信息Id
     */
    @TableField("SJMB_ID")
    private String sjmbId;

    /*****
     * 试卷模板版本号
     */
    @TableField("BBH")
    private String bbh;

    /*****
     * 试题题型代码
     */
    @TableField("STTXDM")
    private String sttxdm;

    /*****
     * 序号
     */
    @TableField("XH")
    private String xh;

    /*****
     * 节段标题
     */
    @TableField("JDBT")
    private String jdbt;

    /*****
     * 试题数量
     */
    @TableField("STSL")
    private BigDecimal stsl;

    /*****
     * 试题总分
     */
    @TableField("STZF")
    private BigDecimal stzf;

    /******
     * 试题题型代码Text
     */
    @TableField(exist = false)
    private String sttxdmText;

    @Override
    public String getId() {
        return mbjdId;
    }

    @Override
    public void setId(String id) {
        this.mbjdId = id;
    }
}
