package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfks.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfksKsxxVo
 * @author ChrisYolanda
 * @description 执法考试考试信息实体类
 * @version 1.0
 * @date 2021-01-08 16:53
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFKSGL_J_KSXX")
public class ZfksKsxxVo extends BaseEntity<String> {

    /*****
     * 考试信息Id
     */
    @TableId
    @TableField("KSXX_ID")
    private String ksxxId;

    /*****
     * 试卷的唯一标识
     */
    @TableField("SJ_ID")
    private String sjId;

    /*****
     * 组织机构ID
     */
    @TableField("ZZJGID")
    private String zzjgid;

    /*****
     * 考试类型代码
     */
    @TableField("KSLXDM")
    private String kslxdm;

    /*****
     * 考试科目代码
     */
    @TableField("KSKMDM")
    private String kskmdm;

    /*****
     * 培训批次信息的唯一标识
     */
    @TableField("PXPCXX_ID")
    private String pxpcxxId;

    /*****
     * 考试名称
     */
    @TableField("KSMC")
    private String ksmc;

    /*****
     * 简介
     */
    @TableField("JJ")
    private String jj;

    /*****
     * 考试开始时间
     */
    @TableField("KSKSSJ")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date kskssj;

    /*****
     * 考试结束时间
     */
    @TableField("KSJSSJ")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date ksjssj;

    /*****
     * 考试时长（单位：分钟）
     */
    @TableField("KSSC")
    private Integer kssc;

    /*****
     * 合格分数
     */
    @TableField("HGFS")
    private String hgfs;

    /*****
     * 是否有培训
     */
    @TableField("SFYPX")
    private String sfypx;

    /*****
     * 状态
     * 0-暂存
     * 1-提交
     */
    @TableField("ZT")
    private String zt;

    /*****
     * 考试方式
     * 0-线下
     * 1-线上
     */
    @TableField("KSFS")
    private String ksfs;

    /*****
     * 人员添加方式
     */
    @TableField("RYTJFS")
    private String rytjfs;

    /*****
     * 学分
     */
    @TableField("XF")
    private String xf;

    /*****
     * 加入代码
     */
    @TableField("JRDM")
    private String jrdm;

    /*****
     * 平均分年龄范围
     */
    @TableField("PJFNLFW")
    private String pjfnlfw;

    /*****
     * 平均分
     */
    @TableField("PJF")
    private Float pjf;

    /*****
     * 打分状态
     * 0-未打分
     * 1-已打分
     */
    @TableField("DFZT")
    private String dfzt;

    /*******
     * 是否允许加入考试
     * 01-允许考试
     * 02-不允许考试
     */
    @TableField(exist = false)
    private String sfyxks;

    /*******
     * 是否允许查看
     * 01-允许查看
     * 02-不允许查看
     */
    @TableField(exist = false)
    private String sfyxck;

    /******
     * 试卷总分
     */
    @TableField(exist = false)
    private String sjzf;

    /******
     * 考试成绩
     */
    @TableField(exist = false)
    private String kscj;

    /******
     * 所获学分
     */
    @TableField(exist = false)
    private String shxf;

    /******
     * 是否通过
     */
    @TableField(exist = false)
    private String sftg;

    /******
     * 是否通过Text
     */
    @TableField(exist = false)
    private String sftgText;

    /*****
     * 用户考试状态
     * 01-未参加考试
     * 02-已参加考试但未计算成绩
     * 03-已参加考试且已计算成绩
     */
    @TableField(exist = false)
    private String yhkszt;

    /*****
     * 用户考试状态Text
     * 01-未参加考试
     * 02-已参加考试但未计算成绩
     * 03-已参加考试且已计算成绩
     */
    @TableField(exist = false)
    private String yhksztText;

    /******
     * 组织机构名称
     */
    @TableField(exist = false)
    private String zzjgmc;

    /******
     * 考试类型代码Text
     */
    @TableField(exist = false)
    private String kslxdmText;

    /******
     * 考试科目代码Text
     */
    @TableField(exist = false)
    private String kskmdmText;

    /******
     * 是否有培训Text
     */
    @TableField(exist = false)
    private String sfypxText;

    /******
     * 状态Text
     */
    @TableField(exist = false)
    private String ztText;

    /******
     * 人员加入方式Text
     */
    @TableField(exist = false)
    private String rytjfsText;

    /******
     * 平均分年龄范围Text
     */
    @TableField(exist = false)
    private String pjfnlfwText;

    /******
     * 打分状态Text
     */
    @TableField(exist = false)
    private String dfztText;

    /******
     * 考试方式Text
     */
    @TableField(exist = false)
    private String ksfsText;

    /*******
     * 是否允许加入考试
     * 01-允许考试
     * 02-不允许考试
     */
    @TableField(exist = false)
    private String sfyxksText;

    @Override
    public String getId() {
        return ksxxId;
    }

    @Override
    public void setId(String id) {
        this.ksxxId = id;
    }

}
