package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfks.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfksKstkVo
 * @author ChrisYolanda
 * @description 考试题库实体类
 * @version 1.0
 * @date 2021-01-30 12:05
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFKSGL_J_KSTK")
public class ZfksKstkVo extends BaseEntity<String> {

    /*****
     * 考试题库Id
     */
    @TableId
    @TableField("KSTK_ID")
    private String kstkId;

    /******
     * 执法门类代码
     */
    @TableField("ZFMLDM")
    private String zfmldm;

    /******
     * 排序
     */
    @TableField("PX")
    private String px;

    /******
     * 题库名称
     */
    @TableField("TKMC")
    private String tkmc;

    /******
     * 题库简介
     */
    @TableField("TKJJ")
    private String tkjj;

    /******
     * 题库状态
     * 0-已保存
     * 1-启用
     * 9-禁用
     */
    @TableField("TKZT")
    private String tkzt;

    /******
     * 启用日期
     */
    @TableField("QYRQ")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date qyrq;

    /*******
     * 组织机构Id
     */
    @TableField("ZZJGID")
    private String zzjgid;

    /******
     * 执法门类代码Text
     */
    @TableField(exist = false)
    private String zfmldmText;

    /******
     * 题库状态Text
     */
    @TableField(exist = false)
    private String tkztText;

    /******
     * 组织机构名称
     */
    @TableField(exist = false)
    private String zzjgmc;

    @Override
    public String getId() {
        return kstkId;
    }

    @Override
    public void setId(String id) {
        this.kstkId = id;
    }
}
