package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfks.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfksKsRyGlVo
 * @author ChrisYolanda
 * @description 执法考试考试人员关联信息实体类
 * @version 1.0
 * @date 2021-01-18 18:17
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFKSGL_J_KS_RY_GL")
public class ZfksKsRyGlVo extends BaseEntity<String> {

    /*****
     * 执法考试考试人员管理信息Id
     */
    @TableId
    @TableField(exist = false)
    private String ksRyGlId;

    /*****
     * 考试信息Id
     */
    @TableField("KSXX_ID")
    private String ksxxId;

    /*****
     * 执法人员信息Id
     */
    @TableField("ZFRYXX_ID")
    private String zfryxxId;

    /*****
     * 组织机构信息Id
     */
    @TableField("ZZJGID")
    private String zzjgid;

    /*****
     * 执法人员姓名
     */
    @TableField("XM")
    private String xm;

    /*****
     * 执法门类代码
     */
    @TableField("ZFMLDM")
    private String zfmldm;

    /*****
     * 性别代码
     */
    @TableField("XBDM")
    private String xbdm;

    /****
     * 身份证件号码
     */
    @TableField("SFZJHM")
    private String sfzjhm;

    /*****
     * 执法证号
     */
    @TableField("ZFZH")
    private String zfzh;

    /*****
     * 组织机构名称
     */
    @TableField("ZFJGMC")
    private String zfjgmc;

    /*****
     * 打分状态
     * 0-未打分
     * 1-已打分
     */
    @TableField("DFZT")
    private String dfzt;

    /*****
     * 考试成绩
     */
    @TableField("KSCJ")
    private String kscj;

    /*****
     * 是否通过
     * 1-是
     * 0-否
     */
    @TableField("SFTG")
    private String sftg;

    /******
     * 试卷编号
     * 日期和流水号组合
     */
    @TableField("SJBH")
    private String sjbh;

    /******
     * 试卷附件id
     */
    @TableField("SJFJID")
    private String sjfjid;

    /*****
     * 交卷时间
     */
    @TableField("JJSJ")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date jjsj;

    /*****
     * 进入考试时间
     */
    @TableField("JRKSSJ")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date jrkssj;

    /******
     * 考生电脑ip
     */
    @TableField("IP")
    private String ip;

    /******
     * 所获学分
     */
    @TableField("SHXF")
    private String shxf;

    /*****
     * 年龄
     */
    @TableField("NL")
    private String nl;

    /******
     * 出生日期
     */
    @TableField("CSRQ")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date csrq;

    /*****
     * 考试所用时长,单位为秒
     */
    @TableField("KSSYSC")
    private Integer kssysc;

    /*****
     * 用户考试状态
     * 01-未参加考试
     * 02-已参加考试,未计算成绩
     * 03-已参加考试.且已计算成绩
     */
    @TableField("YHKSZT")
    private String yhkszt;

    /*****
     * 执法人员信息Id
     */
    @TableField(exist = false)
    private String zfryId;

    /******
     * 考试名称
     */
    @TableField(exist = false)
    private String ksmc;

    /******
     * 考试类型代码
     */
    @TableField(exist = false)
    private String kslxdm;

    /******
     * 考试类型代码Text
     */
    @TableField(exist = false)
    private String kslxdmText;

    /******
     * 考试方式
     */
    @TableField(exist = false)
    private String ksfs;

    /******
     * 考试方式Text
     */
    @TableField(exist = false)
    private String ksfsText;

    /******
     * 是否通过Text
     */
    @TableField(exist = false)
    private String sftgText;

    /*****
     * 考试开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    @TableField(exist = false)
    private Date kskssj;

    /*****
     * 考试结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    @TableField(exist = false)
    private Date ksjssj;

    /*******
     * 人员所属组织机构
     */
    @TableField(exist = false)
    private String ryOrgName;

    /*******
     * 是否允许查看
     * 01-允许查看
     * 02-不允许查看
     */
    @TableField(exist = false)
    private String sfyxck;

    /*******
     * 是否允许查看Text
     * 01-允许查看
     * 02-不允许查看
     */
    @TableField(exist = false)
    private String sfyxckText;

    @Override
    public String getId() {
        return ksRyGlId;
    }

    @Override
    public void setId(String id) {
        this.ksRyGlId = id;
    }
}
