package com.kdgcsoft.jt.xzzf.dubbo.zfry.pub.service;

import com.kdgcsoft.jt.xzzf.common.component.AttachmentVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.pub.entity.XgfjVo;

import java.util.List;

/****
 * @className XgfjService
 * @author chris
 * @description 相关附件服务层接口
 * @version 1.0
 * @date 2021-08-12 17:09
 */
public interface XgfjService {

    /*******
     * 保存相关附件的信息
     * @param ywbId 相关业务表Id
     * @param ywbMc 相关业务表名称
     * @param fjlb 附件类别
     * @param details 附件内容
     * @param user 当前用户
     */
    void saveOrUpdate(String ywbId, String ywbMc, String fjlb, String details, SysUser user);

    /******
     * 获取附件列表信息
     * @param ywbId 相关业务表Id
     * @param ywbMc 相关业务表名称
     * @param fjlb 附件类别
     * @return
     */
    List<AttachmentVo> queryEntityListInfoByYwbIdAndYwbMc(String ywbId, String ywbMc, String fjlb);

    /******
     * 物理删除附件相关信息
     * @param ywbId 相关业务表Id
     * @param ywbMc 相关业务表名称
     * @param fjlb 附件类别
     */
    void deleteEntityInfoByYwbIdAndYwbMc(String ywbId, String ywbMc, String fjlb);

    /*****
     * 逻辑删除附件相关信息
     * @param ywbId 相关业务表Id
     * @param ywbMc 相关业务表名称
     * @param user 当前用户
     */
    void logicDeleteEntityInfoByYwbIdAndYwbMc(String ywbId, String ywbMc, SysUser user);

    /*****
     * 获取附件明细信息
     * @param xgfjId 相关附件Id
     * @return
     */
    XgfjVo getEntityInfoById(String xgfjId);
}
