package com.kdgcsoft.jt.xzzf.dubbo.zfry.constant;

import com.kdgcsoft.jt.xzzf.common.constant.DictConstants;

import java.math.BigDecimal;

/********
 * @Description: 字典常量类
 * @Author: zd
 * @Date: 2019/12/25
 */
public class DictConstant extends DictConstants {

    /********
     * 权力类型
     */
    public static final String DICT_QLLXDM = "QLLXDM";

    /********
     * 执法门类
     */
    public static final String DICT_ZFMLDM = "ZFMLDM";

    /********
     * 时效性
     */
    public static final String DICT_TIME_LINESS = "TIME_LINESS";

    /********
     * 法律法规类别
     */
    public static final String DICT_LAWS_TYPE = "FLFGLBDM";

    /********
     * 行业
     */
    public static final String DICT_HANGYE = "HANGYE";

    /********
     * 执法依据类型
     */
    public static final String DICT_ZFYJLXDM = "ZFYJLXDM";

    /********
     * 自由裁量权等级
     */
    public static final String DICT_ZYCLQDJ = "CDDJDM";

    /********
     * 是
     */
    public static final String DICT_VALUE_YES = "1";

    /********
     * 否
     */
    public static final String DICT_VALUE_NO = "0";

    /********
     * 从业资格证类别代码
     */
    public static final String DICT_CODE_CYZGELBDM = "CYZGZLBDM";

    /********
     * 政治面貌
     */
    public static final String DICT_CODE_ZZMM = "ZZMM";

    /********
     * 民族
     */
    public static final String DICT_CODE_MZ = "MZ";

    /********
     * 从业状态
     */
    public static final String DICT_CODE_CYZT = "CYZT";

    /********
     * 学历代码
     */
    public static final String DICT_CODE_XLDM = "XLDM";

    /********
     * 学历代码大类
     */
    public static final String DICT_CODE_XLDMDL = "ZHGL_XLDMDL";

    /********
     * 证据类型
     */
    public static final String DICT_ZJLX = "ZJLX";

    /********
     * 证据获取方式
     */
    public static final String DICT_ZJHQFS = "ZJHQFS";

    /********
     * 信誉等级
     */
    public static final String DICT_CODE_XYDJ = "XYDJ";

    /***
     * 处罚依据
     */
    public static final String DICT_VALUE_LAYJ = "01";

    /***
     * 处罚依据
     */
    public static final String DICT_VALUE_CFYJ = "02";

    /********
     * 启用
     */
    public static final String DICT_VALUE_QIYONG = "1";

    /********
     * 禁用
     */
    public static final String DICT_VALUE_JINYONG = "0";

    /********
     * 物品类型
     */
    public static final String DICT_VALUE_WPLX = "WPLX";

    /********
     * 物品来源
     */
    public static final String DICT_CODE_WPLY = "WPLY";

    /********
     * 涉案财物处置去向代码
     */
    public static final String DICT_CODE_SACWCZQXDM = "SACWCZQXDM";

    /********
     * 审批状态
     */
    public static final String DICT_CODE_SPZT = "SPZT";

    /********
     * 业户状态代码
     */
    public static final String DICT_CODE_YHZT = "YHZTDM";

    /********
     * 业户类别
     */
    public static final String DICT_CODE_YHLB = "YHLBDM";

    /********
     * 企业类型
     */
    public static final String DICT_CODE_QYLX = "QYLXDM";

    /********
     * 经济性质
     */
    public static final String DICT_CODE_JJXZ = "JJXZDM";

    /********
     * 营业性质
     */
    public static final String DICT_CODE_YYXZ = "YYXZDM";

    /********
     * 年审状态
     */
    public static final String DICT_CODE_NSZT = "ZHGL_ZJNSZT";

    /********
     * 资质等级
     */
    public static final String DICT_CODE_ZZDJ = "ZZDJDM";

    /********
     * 经营范围
     */
    public static final String DICT_CODE_JYFW = "JYFWDM";

    /********
     * 车辆类型代码
     */
    public static final String DICT_CODE_CLXLDM = "CLXLDM";

    /********
     * 车辆状态代码
     */
    public static final String DICT_CODE_CLZTDM = "CLZTDM";

    /********
     * 驱动方式代码
     */
    public static final String DICT_CODE_QDFSDM = "QDFSDM";

    /********
     * 燃料类型代码
     */
    public static final String DICT_CODE_RLLXDM = "RLLXDM";

    /********
     * 车辆技术等级代码
     */
    public static final String DICT_CODE_CLJSDJDM = "CLJSDJDM";

    /********
     * 安装定位系统代码
     */
    public static final String DICT_CODE_AZDWXTDM = "AZDWXTDM";

    /********
     * 天气代码
     */
    public static final String DICT_CODE_TQDM = "TQDM";

    /********
     * 数据来源代码/SJLYDM
     */
    public static final String DICT_CODE_SJLYDM = "SJLYDM";

    /********
     * 巡查问题处置情况代码
     */
    public static final String DICT_CODE_XCWTCZQKDM = "XCWTCZQKDM";

    /********
     * 预警等级代码
     */
    public static final String DICT_CODE_YJDJDM = "YJDJDM";

    /********
     * 提醒类型代码
     */
    public static final String DICT_CODE_TSLXDM = "TSLXDM";
//
//    /********
//     * 是否启用代码
//     */
//    public static final String DICT_CODE_SFQY = "SFQY";

    /********
     * 适任证书类别代码
     */
    public static final String DICT_CODE_SRZSLBDM = "SRZSLBDM";

    /********
     * 检查事项类别代码
     */
    public static final String DICT_CODE_JCSXLBDM = "JCSXLBDM";

    /********
     * 船员注册类别代码
     */
    public static final String DICT_CODE_CYZCLBDM = "CYZCLBDM";

    /********
     * 身份证件类别
     */
    public static final String DICT_CODE_SFZJLXDM = "SFZJLXDM";

    /********
     * 船员专业代码
     */
    public static final String DICT_CODE_CYZYDM = "CYZYDM";

    /********
     * 船舶主机种类代码
     */
    public static final String DICT_CODE_CBZJZLDM = "CBZJZLDM";

    /********
     * 船舶推进器种类代码
     */
    public static final String DICT_CODE_CBTJQZLDM = "CBTJQZLDM";

    /********
     * 航区代码
     */
    public static final String DICT_CODE_HQDM = "HQDM";

    /********
     * 船体材料代码
     */
    public static final String DICT_CODE_CTCLDM = "CTCLDM";

    /********
     * 船舶种类代码
     */
    public static final String DICT_CODE_CBZLDM = "CBZLDM";

    /********
     * 案件状态代码
     * 01-未立案
     */
    public static final String DICT_CODE_AJZT = "AJZT";
    public static final String DICT_VALUE_AJZT_01 = "01";

    /********
     * 检查方式代码
     */
    public static final String DICT_CODE_JCFSDM = "JCFSDM";

    /********
     * 投诉举报状态代码
     */
    public static final String DICT_CODE_TSJBZTDM = "XSCLZTDM";

    /********
     * 信访来源
     */
    public static final String DICT_CODE_XFLYDM = "XFLYDM";

    /********
     * 投诉举报类型
     */
    public static final String DICT_CODE_TSJBLXDM = "TSJBLXDM";

    /********
     * 处罚案件类别
     */
    public static final String DICT_CODE_CFAJLB = "CFAJLB";

    /********
     * 执法人员审批状态
     * 11-待培训
     * 30-待考试
     * 50-待补办换发
     * 99-已发证
     */
    public static final String DICT_CODE_ZFRYSPZT = "ZHGL_ZFRYSPZT";
    public static final String DICT_CODE_ZFRYSPZT_11 = "11";
    public static final String DICT_CODE_ZFRYSPZT_30 = "30";
    public static final String DICT_CODE_ZFRYSPZT_50 = "50";
    public static final String DICT_CODE_ZFRYSPZT_99 = "99";

    /********
     * 执法人员执法门类
     */
    public static final String DICT_CODE_ZFRYZFMLDM = "ZFRYZFMLDM";

    /********
     * 题库类型
     */
    public static final String DICT_CODE_ZHGL_TKLX = "ZHGL_TKLX";

    /********
     * 执法人员职务代码
     */
    public static final String DICT_CODE_ZFRY_ZWDM = "ZWDM";

    /********
     * 执法人员任职状态
     */
    public static final String DICT_CODE_ZFRY_RZZTDM = "RZZTDM";

    /********
     * 执法人员查询范围
     */
    public static final String DICT_CODE_ZFRY_CXFW = "CXFW";

    /********
     * 执法人员证件状态
     * 1-正常
     * 2-挂失
     * 4-暂扣
     * 5-过期未注销
     * 7-挂起
     * 8-吊销
     * 9-注销
     */
    public static final String DICT_CODE_ZFRY_ZJZT = "ZHGL_ZFRYZJZT";
    public static final String DICT_CODE_ZFRY_ZJZT_1 = "1";
    public static final String DICT_CODE_ZFRY_ZJZT_2 = "2";
    public static final String DICT_CODE_ZFRY_ZJZT_4 = "4";
    public static final String DICT_CODE_ZFRY_ZJZT_5 = "5";
    public static final String DICT_CODE_ZFRY_ZJZT_7 = "7";
    public static final String DICT_CODE_ZFRY_ZJZT_8 = "8";
    public static final String DICT_CODE_ZFRY_ZJZT_9 = "9";

    /********
     * 性别
     */
    public static final String DICT_CODE_ZFRY_SEX = "SEX";

    /********
     * 考核项目种类
     * 1-打分项
     * 2-加分项
     * 3-减分项
     * 4-否决项
     */
    public static final String DICT_CODE_KHXMZL = "KHXMZL";
    public static final String DICT_CODE_KHXMZL_1 = "1";
    public static final String DICT_CODE_KHXMZL_2 = "2";
    public static final String DICT_CODE_KHXMZL_3 = "3";
    public static final String DICT_CODE_KHXMZL_4 = "4";

    /********
     * 调动状态
     * 0-调动中
     */
    public static final String DICT_CODE_DDZT = "DDZT";
    public static final String DICT_CODE_DDZT_0 = "0";

    /********
     * 培训类型
     * 0-岗前培训
     * 1-专业培训
     * 2-专业培训
     * 3-其他培训
     */
    public static final String DICT_CODE_ZFRYPXLX = "ZHGL_ZFRYPXLX";
    public static final String DICT_CODE_ZFRYPXLX_0 = "0";
    public static final String DICT_CODE_ZFRYPXLX_1 = "1";
    public static final String DICT_CODE_ZFRYPXLX_2 = "2";
    public static final String DICT_CODE_ZFRYPXLX_3 = "3";

    /********
     * 培训结果
     * 0-不合格
     * 1-合格
     */
    public static final String DICT_CODE_PXJG = "PXJG";
    public static final String DICT_CODE_PXJG_0 = "0";
    public static final String DICT_CODE_PXJG_1 = "1";



    /********
     * 考试科目
     */
    public static final String DICT_CODE_KSKM = "KSKM";



    /********
     * 考试状态
     * 1-提交
     */
    public static final String DICT_CODE_KSZT = "KSZT";
    public static final String DICT_CODE_KSZT_1 = "1";

    /********
     * 考试结果
     */
    public static final String DICT_CODE_KSJG = "KSJG";

    /********
     * 奖励类型
     */
    public static final String DICT_CODE_JLLX = "JLLX";

    /********
     * 惩罚类型
     */
    public static final String DICT_CODE_CFLX = "CFLX";

    /********
     * 人员审批类型
     */
    public static final String DICT_CODE_ZFRY_SPLX = "ZFRYSPLX";

    /********
     * 执法人员变动类型
     * 1-调动
     * 2-退休
     * 3-调离
     */
    public static final String DICT_CODE_BDLX = "BDLX";
    public static final String DICT_CODE_BDLX_1 = "1";
    public static final String DICT_CODE_BDLX_2 = "2";
    public static final String DICT_CODE_BDLX_3 = "3";

    /********
     * 执法人员审批状态
     */
    public static final String DICT_CODE_ZFRYSPSPZT = "ZHGL_ZFRYSPSPZT";

    /********
     * 执法人员岗位代码
     */
    public static final String DICT_CODE_ZFRYGWDM = "ZFRYGWDM";

    /********
     * 过错类型
     */
    public static final String DICT_CODE_GCLX = "GCLX";

    /********
     * 追究方式
     */
    public static final String DICT_CODE_ZJFS = "ZJFS";

    /********
     * 执法责任分类代码
     */
    public static final String DICT_CODE_ZFZRFL = "ZFZRFL";

    /********
     * 题库状态:TKZT
     * 0-已保存
     * 1-启用
     * 9-禁用
     */
    public static final String DICT_CODE_TKZT = "TKZT";
    public static final String DICT_CODE_TKZT_0 = "0";
    public static final String DICT_CODE_TKZT_1 = "1";
    public static final String DICT_CODE_TKZT_9 = "9";

    /********
     * 试卷模板状态
     */
    public static final String DICT_CODE_SJMBZT = "SJMBZT";

    /********
     * 试卷状态
     */
    public static final String DICT_CODE_SJZT = "SJZT";

    /********
     * 分配渠道
     */
    public static final String DICT_CODE_ZFRYFPQD = "ZFRYFPQD";

    /********
     * 执法人员性质
     */
    public static final String DICT_CODE_ZFRYXZ = "ZFRYXZ";

    /********
     * 人员编制
     */
    public static final String DICT_CODE_RYBZ = "RYBZ";

    /********
     * 执法人员职务级别代码
     */
    public static final String DICT_CODE_ZWJBDM = "ZWJBDM";

    /********
     * 试题难度
     */
    public static final String DICT_CODE_STND = "STND";


    /********
     * 试题类型
     * 0-不公开
     * 1-公开
     */
    public static final String DICT_CODE_SFGKLX = "ZHGL_SFGKLX";
    public static final String DICT_CODE_SFGKLX_0 = "0";
    public static final String DICT_CODE_SFGKLX_1 = "1";

    /********
     * 培训批次是否现场培训
     */
    public static final String DICT_CODE_SFXCPX = "SFXCPX";

    /********
     * 培训批次状态
     */
    public static final String DICT_CODE_PXPCZT = "PXPCZT";

    /********
     * 课件管理状态
     */
    public static final String DICT_CODE_KJGLZT = "KJZT";

    /********
     * 课件类型
     */
    public static final String DICT_CODE_KJLX = "KJLX";

    /********
     * 课件阅读方式
     */
    public static final String DICT_CODE_YDFS = "YDFS";

    /********
     * 培训计划类型
     */
    public static final String DICT_CODE_PXLX = "ZHGL_ZFRYPXLX";

    /********
     * 执法号的使用状态
     * 0-未分配
     * 1-已分配
     * 2-已锁定
     */
    public static final String DICT_CODE_SYZT = "SYZT";
    public static final String DICT_CODE_SYZT_1 = "1";
    public static final String DICT_CODE_SYZT_0 = "0";
    public static final String DICT_CODE_SYZT_2 = "2";

    /********
     * 课程状态
     * 1-已发布
     * 2-关闭
     */
    public static final String DICT_CODE_KCZT = "KCZT";
    public static final String DICT_CODE_KCZT_1 = "1";
    public static final String DICT_CODE_KCZT_2 = "2";

    /********
     * 课程分类
     */
    public static final String DICT_CODE_KCFL = "KCFL";

    /********
     * 课程是否公开学习
     */
    public static final String DICT_CODE_SFGKXX = "SFGKXX";

    /********
     * 试题状态
     * 1-启用
     */
    public static final String DICT_CODE_STZT = "STZT";
    public static final String DICT_CODE_STZT_1 = "1";

    /********
     * 考核标准配置类型
     */
    public static final String DICT_CODE_BZFL = "KHBZLX";

    /********
     * 考核标准配置状态
     * 0-暂存
     * 1-待启用
     * 2-启用
     * 3-禁用
     */
    public static final String DICT_CODE_BZZT = "BZZT";
    public static final String DICT_CODE_BZZT_0 = "0";
    public static final String DICT_CODE_BZZT_1 = "1";
    public static final String DICT_CODE_BZZT_2 = "2";
    public static final String DICT_CODE_BZZT_3 = "3";

    /*****
     * 试题题型:STTX
     * 01-单选题
     * 02-多选题
     * 03-填空题
     * 04-判断题
     * 05-简答题
     * 06-操作题
     * 07-案例分析
     */
    public static final String DICT_CODE_STTX = "STTX";
    public static final String DICT_CODE_STTX_06 = "06";
    public static final String DICT_CODE_STTX_07 = "07";
    public static final String DICT_CODE_STTX_05 = "05";
    public static final String DICT_CODE_STTX_04 = "04";
    public static final String DICT_CODE_STTX_03 = "03";
    public static final String DICT_CODE_STTX_02 = "02";
    public static final String DICT_CODE_STTX_01 = "01";


    /******
     * 学分获取途径:HQTJ
     * 1-在线学习
     * 2-线下培训
     * 3-外部培训
     * 4-内部考试
     * 5-上传课程奖励
     */
    public static final String DICT_CODE_HQTJ = "HQTJ";
    public static final String DICT_CODE_HQTJ_1 = "1";
    public static final String DICT_CODE_HQTJ_2 = "2";
    public static final String DICT_CODE_HQTJ_3 = "3";
    public static final String DICT_CODE_HQTJ_4 = "4";
    public static final String DICT_CODE_HQTJ_5 = "5";

    /********
     * 考核结果
     */
    public static final String DICT_CODE_KHJG = "KHJG";

    /********
     * 考核标准分类代码
     */
    public static final String DICT_CODE_BZFLDM = "BZFLDM";

    /********
     * 试卷模板状态
     * 0-暂存
     * 1-启用
     * 9-禁用
     */
    public static final String DICT_CODE_SJMBZT_0 = "0";
    public static final String DICT_CODE_SJMBZT_1 = "1";
    public static final String DICT_CODE_SJMBZT_9 = "9";

    /********
     * 模板的新版本
     */
    public static final String DICT_CODE_STATUS_3 = "3";

    /********
     * 学分申报审核状态:SBZT
     * 1-待审核
     * 2-审核通过
     */
    public static final String DICT_CODE_SBZT = "SBZT";
    public static final String DICT_CODE_SBZT_1 = "1";
    public static final String DICT_CODE_SBZT_2 = "2";

    /********
     * 实卡归属代码:SKGS
     * 1-执法人员自持
     */
    public static final String DICT_CODE_SKGSDM = "SKGS";
    public static final String DICT_CODE_SKGSDM_1 = "1";

    /********
     * 考试方式:KSFS
     * 0-线下
     * 1-线上
     */
    public static final String DICT_CODE_KSFS = "KSFS";
    public static final String DICT_CODE_KSFS_0 = "0";
    public static final String DICT_CODE_KSFS_1 = "1";

    /********
     * 考试类型: ZHGL_KSLX
     * 1-资格考试
     * 3-评议考核
     */
    public static final String DICT_CODE_KSLX = "ZHGL_KSLX";
    public static final String DICT_CODE_KSLX_1 = "1";
    public static final String DICT_CODE_KSLX_3 = "3";

    /********
     * 人员添加方式:RYTJFS
     * 0-手动录入
     * 1-生成代码自主加入
     */
    public static final String DICT_CODE_RYTJFS_0 = "0";
    public static final String DICT_CODE_RYTJFS_1 = "1";

    /********
     * 试卷历史操作状态代码
     */
    public static final String DICT_CODE_CZDM = "CZDM";

    /********
     * 试卷使用用途--评议考核
     */
    public static final String DICT_CODE_SYYT = "2";

    /********
     * 打分状态
     * 0-未打分
     * 1-已打分
     */
    public static final String DICT_CODE_DFZT = "DFZT";
    public static final String DICT_CODE_DFZT_0 = "0";
    public static final String DICT_CODE_DFZT_1 = "1";

    /***
     * 是否通过:SFTG
     * 0-不通过
     * 1-通过
     */
    public static final String DICT_CODE_SFTG = "SFTG";
    public static final String DICT_CODE_SFTG_0 = "0";
    public static final String DICT_CODE_SFTG_1 = "1";


    /********
     * 人员审批状态 资格审批通过
     */
    public static final String DICT_CODE_RYSPZT_11 = "11";
    /********
     * 人员审批状态 培训中
     */
    public static final String DICT_CODE_RYSPZT_20 = "20";
    /********
     * 人员审批状态 培训通过
     */
    public static final String DICT_CODE_RYSPZT_21 = "21";
    /********
     * 人员审批状态 培训未通过
     */
    public static final String DICT_CODE_RYSPZT_22 = "22";

    /***
     * 人员审批状态 考试通过
     */
    public static final String DICT_CODE_RYSPZT_31 = "31";
    /***
     * 人员审批状态 考试未通过
     */
    public static final String DICT_CODE_RYSPZT_32 = "32";
    /********
     * 人员附加信息来源 人工填写
     */
    public static final String DICT_CODE_RYFJXXSJLY_1 = "1";
    /********
     * 人员附加信息来源 系统采集
     */
    public static final String DICT_CODE_RYFJXXSJLY_2 = "2";
    /********
     * 人员附加信息来源 数据导入
     */
    public static final String DICT_CODE_RYFJXXSJLY_3 = "3";
    /***
     * 人员审批状态 未申请
     */
    public static final String DICT_CODE_RYSPZT_00 = "00";
    /***
     * 人员审批状态 已发证
     */
    public static final String DICT_CODE_RYSPZT_99 = "99";
    /***
     * 人员审批状态 待打证
     */
    public static final String DICT_CODE_RYSPZT_60 = "60";
    /********
     * 任职状态 在职
     */
    public static final String DICT_CODE_RZZTDM_0 = "0";
    /********
     * 任职状态 退休
     */
    public static final String DICT_CODE_RZZTDM_3 = "3";
    /********
     * 任职状态 调离 "2"
     */
    public static final String DICT_CODE_RZZTDM_2 = "2";
    /********
     * 审批结果
     */
    public static final String DICT_CODE_SPJG = "SPJG";
    /********
     * 审批结果 不通过
     */
    public static final String DICT_CODE_SPJG_1 = "1";
    /********
     * 审批结果 通过
     */
    public static final String DICT_CODE_SPJG_2 = "2";
    /********
     * 审批类型 1 准入资格审批
     */
    public static final String DICT_CODE_SPLXDM_1 = "1";
    /********
     * 审批类型 2 发证审批
     */
    public static final String DICT_CODE_SPLXDM_2 = "2";
    /********
     * 是否具有法律职业资格
     */
    public static final String DICT_CODE_SFJYFLZYZG = "SFJYFLZYZG";
    /********
     * 是否监督人员
     */
    public static final String DICT_CODE_SFJDRY = "SFJDRY";

    /********
     * 附件信息数据来源 人工填写
     */
    public static final String DICT_CODE_FJSJXXLYDM_1 = "1";
    /********
     * 系统采集
     */
    public static final String DICT_CODE_FJSJXXLYDM_2 = "2";
    /********
     * 数据导入
     */
    public static final String DICT_CODE_FJSJXXLYDM_3 = "3";
    /********
     * 1 为人员信息导入
     */
    public static final String DICT_CODE_DRFLAG_1 = "1";
    /********
     * 人员附加信息导入
     */
    public static final String DICT_CODE_DRFLAG_2 = "2";
    /********
     * 执法人员证件状态 未发证
     */
    public static final String DICT_CODE_ZFRY_ZJZT_0 = "0";
    /********
     * 导出模板类型
     */
    public static final String DICT_CODE_MBDC_1 = "1";
    /********
     * 旧数据带执法证号
     */
    public static final String DICT_CODE_MBDC_3 = "3";
    /********
     * 导出模板第一个sheet的名称
     */
    public static final String DICT_CODE_MBDCNAME = "执法人员基本信息";
    /********
     * 执法人员基本信息和证件信息
     */
    public static final String DICT_CODE_MBDCNAMEZJ = "执法人员基本信息和证件信息";
    /********
     * 执法局组织机构ID
     */
    public static final String DICT_CODE_ZFJID = "8951AB06CA83437EBFD872F52F82E361";
    /********
     * 人员基本信息EXCEL所填数据为空
     */
    public static final String DICT_CODE_EXCELDATANULL = "EXCEL表格数据为空，请重新填写数据";
    /********
     * 人员教育信息EXCEL所填数据为空
     */
    public static final String DICT_CODE_JYEXCELDATANULL = "EXCEL表格教育信息数据为空，请重新填写数据";
    /********
     * 人员培训信息EXCEL所填数据为空
     */
    public static final String DICT_CODE_PXEXCELDATANULL = "EXCEL表格培训信息数据为空，请重新填写数据";
    /********
     * 人员考试信息EXCEL所填数据为空
     */
    public static final String DICT_CODE_KSEXCELDATANULL = "EXCEL表格考试数据为空，请重新填写数据";
    /********
     * 人员奖励信息EXCEL所填数据为空
     */
    public static final String DICT_CODE_JLEXCELDATANULL = "EXCEL表格奖励数据为空，请重新填写数据";
    /********
     * 人员惩罚信息EXCEL所填数据为空
     */
    public static final String DICT_CODE_CFEXCELDATANULL = "EXCEL表格惩罚数据为空，请重新填写数据";
    /********
     * 附加信息的EXCEL表格为空
     */
    public static final String DICT_CODE_FJBGSJWK = "执法人员附加信息表格为空，请重新填写数据";
    /********
     * 身份证号验证
     */
    public static final String RGX = "\\d{15}(\\d{2}[0-9xX])?";

    /********
     * 仅中文的验证
     */
    public static final String ONLYCHINESE = "^[\\u4e00-\\u9fa5]{0,}$";
    /********
     * 证件年审-是否新增执法
     */
    public static final String DICT_CODE_SFXZZF = "SFXZZF";
    /********
     * 退休的证件变化原因
     */
    public static final String BHYX = "人员退休，证件注销";
    /********
     * 调离的证件变化原因
     */
    public static final String BHYX_DL = "人员调离，证件注销";
    /********
     * 考核结果文字 优秀
     */
    public static final String KHJGYX = "优秀（90-100）";
    /********
     * 考核结果文字 良好
     */
    public static final String KHJGLH = "良好（74-89）";
    /********
     * 考核结果文字 一般
     */
    public static final String KHJGYB = "一般（60-74）";
    /********
     * 考核结果文字 不合格
     */
    public static final String KHJGBHG = "不合格（<60）";
    /********
     * 专业分类
     */
    public static final String DICT_CODE_ZYFL = "ZYFL";
    /********
     * 案件类型
     */
    public static final String DICT_CODE_AJLX = "AJLX";
    /********
     * 案件类型 行政许可
     */
    public static final String DICT_CODE_AJLX_1 = "1";
    /********
     * 案件类型
     * 行政处罚
     */
    public static final String DICT_CODE_AJLX_2 = "2";
    /********
     * 案件类型 行政强制
     */
    public static final String DICT_CODE_AJLX_3 = "3";
    /********
     * 字典 评查项目案件类型
     */
    public static final String DIC_AJLX = "AJLX";
    /********
     * 类型名称 处罚
     */
    public static final String DICT_CODE_AJMC_CF = "行政处罚";
    /********
     * 类型名称 许可
     */
    public static final String DICT_CODE_AJMC_XK = "行政许可";
    /********
     * 类型名称 强制
     */
    public static final String DICT_CODE_AJMC_ZK = "行政强制";

    /*****
     * 填写对错:TXDC
     * 0-错
     * 1-对
     */
    public static final String DICT_CODE_TXDC_0 = "0";
    public static final String DICT_CODE_TXDC_1 = "1";

    /********
     * 考试结果 不通过
     */
    public static final String DICT_CODE_TXDC_KSRESULT_1 = "不通过";
    /********
     * 考试结果 通过
     */
    public static final String DICT_CODE_TXDC_KSRESULT_2 = "通过";
    /********
     * 考试方式 自测
     */
    public static final String DICT_CODE_TXDC_KSTYPE_0 = "0";


    /********
     * 执法人员-课程-状态-未开始
     */
    public static final String DICT_CODE_ZFRY_KC_0 = "0";

    /********
     * 执法人员-课程-状态-已开始
     */
    public static final String DICT_CODE_ZFRY_KC_1 = "1";
    /********
     * 执法人员-课程-状态-学习中
     */
    public static final String DICT_CODE_ZFRY_KC_2 = "2";

    /********
     * 执法人员-课程-点赞
     */
    public static final String DICT_CODE_KC_TYPE_DZ = "DZ";
    /********
     * 执法人员-课程-评分
     */
    public static final String DICT_CODE_KC_TYPE_PF = "PF";
    /********
     * 文件服务器
     */
    public static final String FILE_MANAGER_URL = "http://192.168.61.245:9090/";
    public static final String APPCODE = "kdgc@123qwert";

    /********
     * 执法人员-课程-考试答案错
     */
    public static final String DICT_CODE_KC_KSDA_0 = "0";

    /********
     * 执法人员-课程-考试答案对
     */
    public static final String DICT_CODE_KC_KSDA_1 = "1";


    /********
     * 执法人员-课程-考试结果不通过
     */
    public static final String DICT_CODE_KC_KSJG_0 = "0";

    /********
     * 执法人员-课程-考试结果通过
     */
    public static final String DICT_CODE_KC_KSJG_1 = "1";

    /********
     * 执法人员-证件管理-是否撤回 否
     */
    public static final String DICT_CODE_ZJGL_SFCH_0 = "0";

    /********
     * 执法人员-证件管理-是否撤回 是
     */
    public static final String DICT_CODE_ZJGL_SFCH_1 = "1";
    /********
     * 审批类型代码 代表准入资格审批
     */
    public static final String DICT_CODE_SPLX_1 = "1";
    /********
     * 审批类型代码 发证审批
     */
    public static final String DICT_CODE_SPLX_2 = "2";
    /********
     * 试卷状态 审核通过
     */
    public static final String DICT_CODE_SHTG_2 = "2";


    /********
     * 证件年审是否新增执法人员
     */
    public static final String DICT_CODE_ZJNS_SFXZZFRY = "ZHGL_SFXZZFRY";
    /********
     * 证件年审是否一线执法
     */
    public static final String DICT_CODE_ZJNS_SFYXZF = "ZHGL_SFYXZF";
    /********
     * 证件年审培训抽考情况
     */
    public static final String DICT_CODE_ZJNS_PXCKQK = "ZHGL_PXCKQK";
    /********
     * 证件年审执法过失违纪情况
     */
    public static final String DICT_CODE_ZJNS_ZFGSWJQK = "ZHGL_ZFGSWJQK";
    /********
     * 证件年审奖惩情况
     */
    public static final String DICT_CODE_ZJNS_ZJNSJCQK = "ZHGL_ZJNSJCQK";
    /********
     * 证件年审审验结果
     */
    public static final String DICT_CODE_ZJNS_ZJNSJG = "ZHGL_ZJNSJG";
    /********
     * 证件年审操作类型
     */
    public static final String DICT_CODE_ZJNS_CZLX = "ZHGL_CZLX";
    /********
     * 课件类型-文档
     */
    public static final String DICT_CODE_KJLX_0 = "0";
    /********
     * 课件类型-PPT
     */
    public static final String DICT_CODE_KJLX_1 = "1";
    /********
     * 课件类型-视频
     */
    public static final String DICT_CODE_KJLX_2 = "2";
    /********
     * 课件类型-音频
     */
    public static final String DICT_CODE_KJLX_3 = "3";
    /********
     * 安徽省交通运输厅的ID
     */
    public static final String DICT_CODE_AHSJTYST = "A3E3A2810E4E4C1E9ADEA2C09EB03849";
    /********
     * 综合执法局的ID
     */
    public static final String DICT_CODE_AHSJTZHZFJ = "8951AB06CA83437EBFD872F52F82E361";
    /********
     * 学时是否达标
     */
    public static final String DICT_CODE_ZHGL_XSSFDB = "ZHGL_XSSFDB";
    /********
     * 学分是否达标
     */
    public static final String DICT_CODE_ZHGL_XFDB = "ZHGL_XFDB";

    /********
     * 用户的状态
     * 01 正常
     * 02 禁用
     */
    public static final String DICT_CODE_USER_STATUS_01 = "01";
    public static final String DICT_CODE_USER_STATUS_02 = "02";

    /********
     * 是否新增执法
     * 0 否
     * 1 是
     */
    public static final String DICT_CODE_ZJNS_SFXZZFRY_0 = "0";
    public static final String DICT_CODE_ZJNS_SFXZZFRY_1 = "1";

    /********
     * 证件年审培训抽考情况：
     * 0-不合格
     * 1-合格
     */
    public static final String DICT_CODE_ZJNS_PXCKQK_0 = "0";
    public static final String DICT_CODE_ZJNS_PXCKQK_1 = "1";

    /********
     * 证件年审执法过失违纪情况
     * 0 无
     * 1 有
     */
    public static final String DICT_CODE_ZJNS_ZFGSWJQK_0 = "0";
    public static final String DICT_CODE_ZJNS_ZFGSWJQK_1 = "1";

    /********
     * 证件年审奖惩情况
     * 0 均有
     * 1 有奖无罚
     * 2 有罚无奖
     * 3 均无
     */
    public static final String DICT_CODE_ZJNS_ZJNSJCQK_0 = "0";
    public static final String DICT_CODE_ZJNS_ZJNSJCQK_1 = "1";
    public static final String DICT_CODE_ZJNS_ZJNSJCQK_2 = "2";
    public static final String DICT_CODE_ZJNS_ZJNSJCQK_3 = "3";

    /********
     * 证件吊销理由
     */
    public static final String DICT_CODE_ZHGL_ZJDXLY = "ZHGL_ZJDXLY";

    /********
     * 试题 启用
     */
    public static final String DICT_CODE_QY = "qy";
    /********
     * 试题 禁用
     */
    public static final String DICT_CODE_JY = "JY";

    /********
     * 人员审批的锁定状态
     * 0  未锁定
     * 1  锁定
     */
    public static final String DICT_CODE_SDZT_0 = "0";
    public static final String DICT_CODE_SDZT_1 = "1";

    /********
     * 宿松县CODE
     */
    public static final String DICT_CODE_SUSONGCODE = "3408260000";

    /********
     * 广德CODE
     */
    public static final String DICT_CODE_GUANGDECODE = "3418220000";
    /********
     * 安徽省的ORGCODE
     */
    public static final String DICT_CODE_ANHUISHENGCODE = "3400000000";
    /********
     * 安徽执法局的ORGCODE
     */
    public static final String DICT_CODE_ANHUISHENGZFJCODE = "3400010000";
    /********
     * 安徽路政支队的ORGCODE
     */
    public static final String DICT_CODE_ANHUISHENGLZZDODE = "3400010100";

    /********
     *  echart课程分类查询位数_1
     */
    public static final Integer ECHART_KCFL_DISIT_1 = 1;
    /********
     * echart课程分类查询位数_2
     */
    public static final Integer ECHART_KCFL_DISIT_2 = 2;
    /********
     * echart课程分类查询位数_3
     */
    public static final Integer ECHART_KCFL_DISIT_3 = 3;

    /********
     * echart课程点击量查询年份范围，前三年
     */
    public static final Integer ECHART_DJL_YEAR_SIZE_3 = 3;

    /********
     *  echart线下培训今年标识
     */
    public static final String ECHART_XXPX_YEAR = "01";
    /********
     * echart线下培训本月标识
     */
    public static final String ECHART_XXPX_MONTH = "02";

    /********
     * 组织机构等级 省级(01,02)
     */
    public static final String DIC_CODE_ORG_LEVEL_1 = "01,02";

    /********
     * 组织机构等级  市级(03,04)
     */
    public static final String DIC_CODE_ORG_LEVEL_2 = "03,04";
    /********
     * 组织机构等级  市级不包含市支队
     */
    public static final String DIC_CODE_ORG_LEVEL_3 = "03";

    /********
     * 必修课
     */
    public static final String DICT_CODE_ONLINETYPE_1 = "1";
    /********
     * 选修课
     */
    public static final String DICT_CODE_ONLINETYPE_2 = "2";
    /********
     * 学分
     */
    public static final String DICT_CODE_TYPE_GR_1 = "1";
    /********
     * 学时
     */
    public static final String DICT_CODE_TYPE_GR_2 = "2";
    /********
     * 自定义案件类别 处罚强制
     */
    public static final String DICT_CODE_ZDYAJLB_2 = "2";
    /********
     * 执法证号解锁方式 立即解锁
     */
    public static final String DICT_CODE_JSFS_1 = "1";
    /********
     * 执法证号解锁方式 定时解锁
     */
    public static final String DICT_CODE_JSFS_2 = "2";
    /********
     * 个人首页待考试跳转
     */
    public static final String DICT_CODE_DKSLINK = "KSCX";
    /********课程学习考试通过比率*/
    public static final BigDecimal KCKS_RATE_TG = new BigDecimal(0.6);

    /*****
     * 执法考试人员的考试状态
     * 01-未参加考试
     * 02-已参加考试但未计算成绩
     * 03-已参加考试且已计算成绩
     */
    public static final String DICT_CODE_ZFRY_ZFKS_YHKSZT = "ZFRY_ZFKS_YHKSZT";
    public static final String DICT_CODE_ZFRY_ZFKS_YHKSZT_01 = "01";
    public static final String DICT_CODE_ZFRY_ZFKS_YHKSZT_02 = "02";
    public static final String DICT_CODE_ZFRY_ZFKS_YHKSZT_03 = "03";

    /*******
     * 是否允许加入考试
     * 01-允许考试
     * 02-不允许考试
     */
    public static final String DICT_CODE_ZFRY_ZFKS_SFYXKS = "ZFRY_ZFKS_SFYXKS";
    public static final String DICT_CODE_ZFRY_ZFKS_SFYXKS_01 = "01";
    public static final String DICT_CODE_ZFRY_ZFKS_SFYXKS_02 = "02";

    /*******
     * 是否允许查看
     * 01-允许查看
     * 02-不允许查看
     */
    public static final String DICT_CODE_ZFRY_ZFKS_SFYXCK = "ZFRY_ZFKS_SFYXCK";
    public static final String DICT_CODE_ZFRY_ZFKS_SFYXCK_01 = "01";
    public static final String DICT_CODE_ZFRY_ZFKS_SFYXCK_02 = "02";

    /********
     * 是否过关：SFGG
     * 0-否
     * 1-是
     */
    public static final String DICT_CODE_SFGG = "SFGG";
    public static final String DICT_CODE_SFGG_0 = "0";
    public static final String DICT_CODE_SFGG_1 = "1";

    /*******
     * 题库练习标识:TKLXBS
     * 01-未参与练习
     * 02-已参与练习
     */
    public static final String DICT_CODE_TKLXBS = "TKLXBS";
    public static final String DICT_CODE_TKLXBS_01 = "01";
    public static final String DICT_CODE_TKLXBS_02 = "02";

    /********
     * 纠错提醒处理状态:JCTX
     * 0-未处理 0
     * 1-已处理 1
     */
    public static final String DICT_CODE_TXDC_JCTXCLZT = "JCTX";
    public static final String DICT_CODE_TXDC_JCTXCLZT_0 = "0";
    public static final String DICT_CODE_TXDC_JCTXCLZT_1 = "1";

    /*******
     * 年度学分记录是否达标:ZHGL_XSSFDB
     * 0-否
     * 1-是
     */
    public static final String DICT_CODE_NDXFGL_SFDB = "ZHGL_XSSFDB";
    public static final String DICT_CODE_NDXFGL_SFDB_0 = "0";
    public static final String DICT_CODE_NDXFGL_SFDB_1 = "1";

    /******
     * 错题标志:ZHGL_ZFKS_CTBZ
     * 0-未标注
     * 1-已标志
     */
    public static final String DICT_CODE_ZFKS_CTBZ = "ZHGL_ZFKS_CTBZ";
    public static final String DICT_CODE_ZFKS_CTBZ_0 = "0";
    public static final String DICT_CODE_ZFKS_CTBZ_1 = "1";

    /******
     * 标记标志:ZHGL_ZFKS_BJBZ
     * 0-未标注
     * 1-已标志
     */
    public static final String DICT_CODE_ZFKS_BJBZ = "ZHGL_ZFKS_BJBZ";
    public static final String DICT_CODE_ZFKS_BJBZ_0 = "0";
    public static final String DICT_CODE_ZFKS_BJBZ_1 = "1";

    /*******
     * 做题方式:ZHGL_TKLX_ZTFS
     * 01-继续做题
     * 02-重新开始(开始做题)
     */
    public static final String DICT_CODE_TKLX_ZTFS = "ZHGL_TKLX_ZTFS";
    public static final String DICT_CODE_TKLX_ZTFS_01 = "01";
    public static final String DICT_CODE_TKLX_ZTFS_02 = "02";

    /*******
     * 考核项目层级:KHXMCJ
     *  1-一级
     *  2-二级
     */
    public static final String DICT_CODE_KHXM_CJ="KHXMCJ";
    public static final String DICT_CODE_KHXM_CJ_1="1";
    public static final String DICT_CODE_KHXM_CJ_2="2";

    /*******
     * 是否考核:SFKH
     *  0-未考核
     *  1-已考核
     */
    public static final String DICT_CODE_SFKH="SFKH";
    public static final String DICT_CODE_SFKH_0="0";
    public static final String DICT_CODE_SFKH_1="1";

    /*******
     * 是否公开练习:SFGKLX
     *  0-否
     *  1-是
     */
    public static final String DICT_CODE_ZHGL_SFGKLX="ZHGL_SFGKLX";
    public static final String DICT_CODE_ZHGL_SFGKLX_0="0";
    public static final String DICT_CODE_ZHGL_SFGKLX_1="1";
}
