package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zjgl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysOrg;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zjgl.entity.ZfZjXxVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zjgl.entity.ZjNsXxVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zjgl.entity.ZjNsczjlVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zjgl.entity.ZjnsExportDataModel;

import java.util.List;


/**
 * <p>
 * 证件年审信息 服务类
 * </p>
 *
 * @author 孙晓东
 * @since 2020-04-01
 */
public interface ZjNsXxService {

    /**
     * 新增证件年审信息信息
     *
     * @param zjNsXxVO
     * @return
     */
    boolean insert(ZjNsXxVO zjNsXxVO, SysUser curUser);

    /**
     * 更新证件年审信息信息
     *
     * @param zjNsXxVO
     * @return
     */
    boolean update(ZjNsXxVO zjNsXxVO);

    /**
     * 上报
     *
     * @param zjNsXxVO
     * @return
     */
    boolean updateZt(ZjNsXxVO zjNsXxVO, SysUser curUser, String czlx);


    /**
     * 根据证件ID和年度获取证件年审信息信息
     *
     * @param zjId
     * @param nsnd
     * @return
     */
    ZjNsXxVO getByIdANd(String zjId, String nsnd);

    /**
     * 根据证件ID和年度获取证件年审信息信息(包含人员信息)
     *
     * @param zjId
     * @param nsnd
     * @return
     */
    ZjNsXxVO selectByZjId(String zjId, String nsnd);


    /**
     * 分页查询
     *
     * @param current  当前页
     * @param size     每页显示条数
     * @param zjnsxxvo
     * @return
     */
    Page<ZjNsXxVO> page(long current, long size, ZjNsXxVO zjnsxxvo);

    /**
     * 查询当前组织机构 年审年度 的年审信息
     *
     * @param zzjgId
     * @param nsnd
     * @return
     */
    List<ZjNsXxVO> listByZzjgId(String zzjgId, String nsnd);

    /**
     * 审核分页查询
     *
     * @param current 当前页
     * @param size    每页显示条数
     * @param nszt    年审状态
     * @param nsnd    年审年度
     * @param orgId   当前组织机构id
     * @return
     */
    Page<ZjNsXxVO> pageSh(long current, long size, String nszt, String nsnd, String orgId);

    /**
     * 查询导出的年审信息
     *
     * @param zjNsXxVO
     * @return
     */
    List<ZjnsExportDataModel> getExcelData(ZjNsXxVO zjNsXxVO);

    /**
     * 审核分页查询
     *
     * @param zjNsczjlVO
     * @return
     */
    boolean saveSh(ZjNsczjlVO zjNsczjlVO, String nszt);

    /**
     * 查询证件年审记录
     *
     * @param current
     * @param size
     * @param zfzjxxId
     * @return
     */
    Page<ZjNsXxVO> zjnsjlpage(long current, long size, String zfzjxxId);

    /**
     * 查询证件年审流程记录
     *
     * @param current
     * @param size
     * @param zjnsxxId
     * @return
     */
    Page<ZjNsczjlVO> nslcjlpage(long current, long size, String zjnsxxId);

    /**
     * 根据ID获取证件年审信息信息
     *
     * @param id
     * @return
     */
    ZjNsXxVO getById(String id);

    /**
     * 更新责任信息
     *
     * @param zjNsXxVO
     * @return
     */
    Result updatezjnsxx(ZjNsXxVO zjNsXxVO);

    /**
     * 判断当前用户组织机构是否还有下级
     *
     * @param orgId
     * @return
     */
    boolean hasNextOrg(String orgId);

    /**
     * 查询当前组织机构是否还有待年审数据
     *
     * @return
     */
    boolean hasDns(ZjNsXxVO zjNsXxVO);

    /**
     * 查询当前用户组织下所有执法证件
     *
     * @return
     */
    Page<ZfZjXxVO> getZfzjxxIds(long current, long size, ZfZjXxVO zfZjXxVO);

    /**
     * 查询下级组织机构（只到子级）
     *
     * @return
     */
    List<SysOrg> getOrgInfoByPid(String orgId);

    /**
     * 查询该组织机构年审上报情况
     *
     * @return
     */
    boolean queryNssb(String nsnd, String nszt, String orgId);

    /**
     * 查询执法人员个人信息的年审
     * @param current
     * @param size
     * @param zjNsXxVO
     * @return
     */
    Page<ZjNsXxVO> queryZfryqdNsInfo(long current, long size, ZjNsXxVO zjNsXxVO);
}

