package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zjgl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.ZfRyXxVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zjgl.entity.*;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 执法证件信息 服务类
 * </p>
 *
 * @author 黄宇
 * @since 2020-03-25
 */
public interface ZfZjXxService {

    /**
     * 证件管理页面分页查询
     *
     * @param current
     * @param size
     * @param zfZjXxVO
     * @return
     */
    Page<ZfZjXxVO> page(long current, long size, ZfZjXxVO zfZjXxVO);

    /**
     * 查询统计-证件管理页面分页查询
     *
     * @param current
     * @param size
     * @param zfZjXxVO
     * @return
     */
    Page<ZfZjXxVO> tjpage(long current, long size, ZfZjXxVO zfZjXxVO);

    /**
     * 查询统计-证件管理页面导出
     *
     * @param zfZjXxVO
     * @return
     */
    List<ZjCxTjExportDataModel> tjList(ZfZjXxVO zfZjXxVO);

    /**
     * 证件状态饼图查询
     *
     * @param zfZjXxVO
     * @return
     */
    List<Map<String,Object>> btPage(ZfZjXxVO zfZjXxVO);
    /**
     * 证件状态历史操作记录数量查询
     *
     * @param zfZjXxVO
     * @return
     */
    List<Map<String,Object>> zjSlTj(ZfZjXxVO zfZjXxVO);
    /**
     * 证件状态折线图图查询-今年
     *
     * @param zfZjXxVO
     * @return
     */
    List<Map<String,Object>> lineLsitByNd(ZfZjXxVO zfZjXxVO);
    /**
     * 证件状态折线图图查询-当前月
     *
     * @param zfZjXxVO
     * @return
     */
    List<Map<String,Object>> lineLsitByYf(ZfZjXxVO zfZjXxVO);

    /**
     * 根据ID查询执法证件信息
     *
     * @param zfzjxxId
     * @return
     */
    ZfZjXxVO getById(String zfzjxxId);

    /***
     * 操作执法证件
     * @param zfZjXxVO
     * @param zjLsJlVO
     * @param zfRyXxVO
     * @return
     */
    Boolean operateZjXx(ZfZjXxVO zfZjXxVO, ZjLsJlVO zjLsJlVO, ZfRyXxVO zfRyXxVO, ZfHxXVO zfHxXVO);

    /**
     * 查询条件导出
     *
     * @param zfZjXxVO
     * @return
     */
    List<ZfZjXxVO> daochuZjXxByQuery(ZfZjXxVO zfZjXxVO);

    /**
     * 勾选导出
     *
     * @param zfZjXxVO
     * @return
     */
    List<ZfZjXxVO> daochuZjXxByGx(ZfZjXxVO zfZjXxVO);

    /**
     * 批量操作注销证件信息
     *
     * @param zfzjList
     * @param zjLsJlVOList
     * @param zfRyXxVOList
     * @param zfHxXVOList
     * @return
     */
    Boolean operateZjXxByPiLiang(List<ZfZjXxVO> zfzjList, List<ZjLsJlVO> zjLsJlVOList, List<ZfRyXxVO> zfRyXxVOList, List<ZfHxXVO> zfHxXVOList);

    /**
     * 查询证件历史记录
     *
     * @param zfzjxxId
     * @return
     */
    List<ZjLsJlVO> getViewZjLsJl(String zfzjxxId);

    /***
     * 得到操作人姓名
     * @param creater
     * @return
     */
    String getczrXM(String creater);

    /***
     * 根据主键查询执法证件历史记录
     * @param zjlsjlId
     * @return
     */
    ZjLsJlVO getOneZfZjLs(String zjlsjlId);

    /***
     * 查询最近的一条证件历史记录
     * @param zjLsJlVO
     * @return
     */
    ZjLsJlVO getLatelyLsjl(ZjLsJlVO zjLsJlVO);

    /**
     * 撤回操作
     *
     * @param zjXxVO
     * @param zfRyXxVO
     * @param zjlsjl
     * @return
     */
    Boolean recallZjXx(ZfZjXxVO zjXxVO, ZfRyXxVO zfRyXxVO, ZjLsJlVO zjlsjl, ZfHxXVO zfHxXVO);

    /**
     * 统计个数
     *
     * @param zfZjXxVO
     * @return
     */
    int countYxQzJ(ZfZjXxVO zfZjXxVO);

    /**
     * 查询吊销理由的下拉框数据
     *
     * @return
     */
    List<ComboboxVo> queryDxLyCombox();

    /**
     * 查询吊销理由名称
     *
     * @param dxlydm
     * @return
     */
    String queryDxlymc(String dxlydm);

    /**
     * 定时任务 更新证件状态
     *
     * @param zfZjXxVO
     */
    void updateZjZt(ZfZjXxVO zfZjXxVO);

    /**
     * 首页执法证件数量统计
     *
     * @param cxfw
     * @param sj
     * @param curUser
     * @return
     */
    SyZfZjTjVO querySyZfZjInfo(String cxfw, String sj, SysUser curUser);

    /**
     * 仁怀查询未登记的人员列表信息
     * @param current
     * @param size
     * @param zfRyXxVO
     * @return
     */
    Page<ZfRyXxVO> queryNullZfZjRyInfo(long current, long size, ZfRyXxVO zfRyXxVO);

    /**
     * 仁怀登记执法证件数据
     * @param zfZjXxVO
     * @param curUser
     * @return
     */
    Boolean insertZfZjInfo(ZfZjXxVO zfZjXxVO, SysUser curUser);
}

