package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zjgl.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.TreeDataVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zjgl.entity.ZfHdXxVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zjgl.entity.ZfHxXVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zjgl.entity.ZfZjXxVO;

import java.util.List;
import java.util.Map;


/**
 * <p>
 * 执法号信息 服务类
 * </p>
 *
 * @author 黄宇
 * @since 2020-03-25
 */
public interface ZfHxXService {

    /**
     * 根据执法证号获取信息
     * @param zfzh
     * @return
     */
    ZfHxXVO getZfHXx(String zfzh);

    /**
     * 执法号列表查询
     * @param current
     * @param size
     * @param zfHdXxVO
     * @return
     */
    Page<ZfHdXxVO> page(long current, long size, ZfHdXxVO zfHdXxVO);

    /**
     * 新增执法号
     * @param zfHdXxVO
     * @return
     */
    Boolean addZfZh(ZfHdXxVO zfHdXxVO);

    /**
     * 更新执法号
     * @param zfHdXxVO
     * @return
     */
    Boolean updateZfZh(ZfHdXxVO zfHdXxVO);

    /**
     *根据组织机构ID查询执法号段信息
     * @param zzjgid
     * @return
     */
    ZfHdXxVO getZfHdVO(String zzjgid);

    /**
     * 校验用户所选号段范围
     * @param zfHdXxVO
     * @return
     */
    Boolean checkHdFw(ZfHdXxVO zfHdXxVO);

    /**
     * 根据主键ID获取信息
     * @param zfhdxxId
     * @return
     */
    ZfHdXxVO getZfHdXxById(String zfhdxxId);

    /**
     * 逻辑删除执法号段
     * @param zfHdXxVO
     * @return
     */
    Boolean deleteZfHdXx(ZfHdXxVO zfHdXxVO);

    /**
     * 根据执法号段ID查找执法号信息
     * @param zfHxXVO
     * @return
     */
    Page getZfHXxList(long current, long size, ZfHxXVO zfHxXVO);

    /**
     * 解锁执法号
     */
    void unLockZfh(ZfHxXVO zfHxXVO);

    /**
     * 根据执法证号查询分配记录
     * @param current
     * @param size
     * @param zfzh
     * @return
     */
    Page<ZfZjXxVO> selectFpjLInfo(long current, long size, String zfzh);

    /**
     * 页面选择解锁执法证号
     * @param zfHxXVO
     * @return
     */
    Boolean jieSuoZfZh(ZfHxXVO zfHxXVO);

    /**
     * 获取执法证号
     * @param zzjgId
     * @return
     */
    Map<String,String> getZfZh(String zzjgId,String zfzh);

    /**
     * 新增执法证号
     * @param zfryxxId
     * @param zfzh
     * @param curUser
     * @return
     */
    boolean updateNewZfZh(String zfryxxId, String zfzh, SysUser curUser,String zfhdId,String flag);

    /**
     * 查询省厅和16个地市的组织机构树
     * @return
     */
    List<TreeDataVo> queryDsTreeDataInfo();
}

