package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zjgl.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 * <p>
 * 年审操作记录表
 * </p>
 *
 * @author lxr
 * @since 2020-07-22
 */
@Data
@TableName("ZFZJGL_J_NSCZJLB")
public class ZjNsczjlVO implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 年审操作记录表的唯一标识
     */
    @TableId
    private String nsczjlbId;

    /**
     * 证件年审信息的唯一标识
     */
    private String zjnsxxId;

    /**
     * 操作人员所在机构ID
     */
    private String zzjgid;

    /**
     * 操作人员所在机构名称
     */
    private String zzjgmc;

    /**
     * 操作人姓名
     */
    private String czrxm;

    /**
     * 负责人姓名
     */
    private String fzrxm;

    /**
     * 操作类型：1 初审，2 上报审核，3 审核，4 上报备案
     */
    private String czlx;

    /**
     * 审验结果代码
     */
    private String syjgdm;

    /**
     * 审核意见
     */
    private String shyj;
    /**
     * 审核修改信息
     */
    @TableField(exist = false)
    private String nsinfo;
    /**
     * 创建人
     */
    @TableField(fill = FieldFill.INSERT)
    public String creater;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    public Date createTime;

    /**
     * 审核日期
     */
    @TableField(exist = false)
    private String shrq;
}
