package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zjgl.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.entity.KsRyGlVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.KhJlBVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.RyCfXxVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.RyJlXxVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.RyzrzjxxVO;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 证件年审信息
 * </p>
 *
 * @author 孙晓东
 * @since 2020-04-01
 */
@Data
@TableName("ZFZJGL_J_ZJNSXX")
public class ZjNsXxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 证件年审信息的唯一标识
     */
    @TableId
    private String zjnsxxId;
    /**
     * 执法人员基本信息的唯一标识。
     */
    @TableField(exist = false)
    private String zfryxxId;

    /**
     * 从事执法日期
     */
    @TableField(exist = false)
    private Date cszfrq;
    /**
     * 执法证件信息的唯一标识。
     */
    private String zfzjxxId;

    /**
     * 审验结果代码
     */
    private String syjgdm;

    /**
     * 是否新增执法人员，0 否 1 是
     */
    private String sfxzzfry;

    /**
     * 是否一线执法，0 否 1 是
     */
    private String sfyxzf;

    /**
     * 执法证件管理情况
     */
    private String zfzjglqk;

    /**
     * 执法或人事考核情况
     */
    private String zfhrskhqk;

    /**
     * 执法或人事考核情况--统计出来
     */
    @TableField(exist = false)
    private String sJzfhrskhqk;
    /**
     * 培训抽考情况
     */
    private String pxckqk;
    /**
     * 培训抽考情况--统计出来
     */
    @TableField(exist = false)
    private String sJpxckqk;
    /**
     * 执法过失违纪情况
     */
    private String zfgswjqk;
    /**
     * 执法过失违纪情况--统计出来
     */
    @TableField(exist = false)
    private String sJzfgswjqk;
    /**
     * 奖惩情况
     */
    private String jcqk;
    /**
     * 奖惩情况--统计出来
     */
    @TableField(exist = false)
    private String sJjcqk;
    /**
     * 年审年度
     */
    private String nsnd;
    /**
     * 年审日期
     */
    @JSONField(format = "yyyy-MM-dd")
    private Date nsrq;
    /**
     * 说明
     */
    private String sm;

    /**
     * 状态：0 未上报 1 已上报
     */
    private String zt;
    /**
     * 状态：0 未上报 1 已上报
     */
    @TableField(exist = false)
    private Boolean ztFlag;
    /**
     * 执法人员的姓名
     */
    private String xm;
    /**
     * 执法证号
     */
    private String zfzh;
    /**
     * 执法机构名称
     */
    private String zfjgmc;
    /**
     * 执法人员执法门类的名称
     */
    private String zfmlmc;
    /**
     * 人员职务的名称
     */
    private String zwmc;
    /**
     * 学历名称
     */
    private String xlmc;
    /**
     * 审核日期
     */
    @JSONField(format = "yyyy-MM-dd")
    private Date sbbarq;
    /**
     * 执法门类代码
     */
    @TableField(exist = false)
    private String zfmldm;
    /**
     * 年龄
     */
    private String nl;

    /**
     * 执法机构id
     */
    private String zzjgid;
    /**
     * 执法机构上级id（登录账号是市执法局使用）
     */
    @TableField(exist = false)
    private String orgPid;

    /**
     * 执法机构等级
     */
    @TableField(exist = false)
    private String orgLevel;

    /**
     * 执法证件状态
     */
    @TableField(exist = false)
    private String zjztdm;
    /**
     * 实卡归属代码
     */
    @TableField(exist = false)
    private String skgsdm;
    /**
     * 查询范围
     */
    @TableField(exist = false)
    private String cxfw;
    /**
     * 证件年审id数组
     */
    @TableField(exist = false)
    private String[] zjnsxxIds;
    /**
     * 考核信息列表
     */
    @TableField(exist = false)
    private List<KhJlBVO> zfhrskhqkList;
    /**
     * 培训抽考信息列表
     */
    @TableField(exist = false)
    private List<KsRyGlVO> pxckqkList;
    /**
     * 责任追究信息列表
     */
    @TableField(exist = false)
    private List<RyzrzjxxVO> zjlist;
    /**
     * 奖励列表
     */
    @TableField(exist = false)
    private List<RyJlXxVO> jllist;
    /**
     * 惩罚列表
     */
    @TableField(exist = false)
    private List<RyCfXxVO> cflist;
    /**
     * 年审日期字符串
     */
    @TableField(exist = false)
    private String nsrqStr;
    /**
     * 导出年审信息的组织机构ids
     */
    @TableField(exist = false)
    private String[] orgIdArr;

    @Override
    public String getId() {
        return zjnsxxId;
    }

    @Override
    public void setId(String id) {
        this.zjnsxxId = id;
    }
}

