package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zjgl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;


/**
 * <p>
 * 执法证件信息
 * </p>
 *
 * @author 黄宇
 * @since 2020-03-25
 */
@Data
@TableName("ZFZJGL_J_ZFZJXX")
public class ZfZjXxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 执法证件信息的唯一标识。
     */
    @TableId
    private String zfzjxxId;

    /**
     * 执法人员基本信息的唯一标识。
     */
    private String zfryxxId;

    /**
     * 证件状态代码
     */
    private String zjztdm;

    /**
     * 实卡归属代码
     */
    private String skgsdm;

    /**
     * 执法人员的姓名。
     */
    private String xm;

    /**
     * 执法人员执法门类的代码。
     */
    private String zfmldm;

    /**
     * 执法证号
     */
    private String zfzh;

    /**
     * 人员的岗位代码。
     */
    private String gwdm;

    /**
     * 执法人员的执法区域。
     */
    private String zfqy;

    /**
     * 执法机构名称
     */
    private String zfjgmc;

    /**
     * IC卡芯片出厂号（IC固有的物理号）
     */
    private String kwlbh;

    /**
     * 发证日期
     */
    private Date fzrq;

    /**
     * 有效期起
     */
    private Date yxqq;

    /**
     * 有效期止
     */
    private Date yxqz;

    /**
     * 发证人
     */
    private String fzr;

    /**
     * 发证机关
     */
    private String fzjg;

    /**
     * 变化原因
     */
    private String bhyy;

    /**
     * 变化时间
     */
    private Date bhsj;

    /**
     * 执法机构ID
     */
    private String zzjgid;
    /**
     * 责任信息ID
     */
    private String zrxxId;

    /**                      表外字段                   **/
    /**
     * 查询范围
     */
    @TableField(exist = false)
    private String cxfw;
    /***
     * 过期时间
     */
    @TableField(exist = false)
    private String gqsj;


    /**
     * 证件状态代码 字典值
     */
    @TableField(exist = false)
    private String zjztdmCode;

    /**
     * 当前时间
     */
    @TableField(exist = false)
    private Date nowDate;

    /**
     * 证件ID数组
     */
    @TableField(exist = false)
    private String zfzjxxIdS[];

    /**
     * 有效期起
     */
    @TableField(exist = false)
    private String yxqqStr;
    /**
     * 有效期止
     */
    @TableField(exist = false)
    private String yxqzStr;

    /**
     * 发证日期
     */
    @TableField(exist = false)
    private String fzrqStr;

    /**
     * 所属机构名称
     */
    @TableField(exist = false)
    private String orgName;

    /**
     * 所属机构id
     */
    @TableField(exist = false)
    private String orgId;
    /**
     * 性别
     */
    @TableField(exist = false)
    private String xbdm;
    /**
     * 身份证件号码
     */
    @TableField(exist = false)
    private String sfzjhm;

    /**
     * 职务代码
     */
    @TableField(exist = false)
    private String zwdm;
    /**
     * 职务名称
     */
    @TableField(exist = false)
    private String zwmc;
    /**
     * 考核结果
     */
    @TableField(exist = false)
    private String pxckqk;
    /**
     * 学历名称
     */
    @TableField(exist = false)
    private String xlmc;

    /**
     * 说明
     */
    @TableField(exist = false)
    private String sm;
    /**
     * 标记
     */
    @TableField(exist = false)
    private String flag;
    /**
     * 证件统计标记 0 今年 1当前月
     */
    @TableField(exist = false)
    private String cxflag;
    /**
     * 人员审批状态代码
     */
    @TableField(exist = false)
    private String ryspztdm;
    /**
     * 年审年度使用
     */
    @TableField(exist = false)
    private String nsnd;
    /**
     * 年龄
     */
    @TableField(exist = false)
    private String age;
    /**
     * 分配时间
     */
    @TableField(exist = false)
    private String fpsjStr;
    @Override
    public String getId() {
        return zfzjxxId;
    }

    @Override
    public void setId(String id) {
        this.zfzjxxId = id;
    }


}
