package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zjgl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 执法号信息
 * </p>
 *
 * @author 黄宇
 * @since 2020-03-25
 */
@Data
@TableName("ZFZJGL_J_ZFHXX")
public class ZfHxXVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 执法号信息的唯一标识
     */
    @TableId
    private String zfhxxId;

    /**
     * 执法号段信息的唯一标识
     */
    private String zfhdxxId;

    /**
     * 执法证号
     */
    private String zfzh;

    /**
     * 0 未分配 1 已分配 2 已锁定
     */
    private String syzt;

    /**
     * 分配时间
     */
    private Date fpsj;

    /**
     * 锁定时间
     */
    private Date sdsj;

    /**
     * 待解锁时间
     */
    private String djssj;
    /**
     * 解锁时间
     */
    private Date jssj;

    /**            表外字段             **/
    /**
     * 标记
     */
    @TableField(exist = false)
    private String flag;
    /**
     * 使用状态的编码
     */
    @TableField(exist = false)
    private String syztCode;

    @Override
    public String getId() {
        return zfhxxId;
    }

    @Override
    public void setId(String id) {
        this.zfhxxId = id;
    }


}
