package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zjgl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/**
 * <p>
 * 执法号段信息
 * </p>
 *
 * @author 黄宇
 * @since 2020-04-11
 */
@Data
@TableName("ZFZJGL_J_ZFHDXX")
public class ZfHdXxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 执法号段信息的唯一标识
     */
    @TableId
    private String zfhdxxId;

    /**
     * 组织机构ID
     */
    private String zzjgid;

    /**
     * 执法机构名称
     */
    private String zfjgmc;

    /**
     * 号段起
     */
    private String hdq;

    /**
     * 号段止
     */
    private String hdz;

    /**
     * 备注
     */
    private String bz;

    /**                  表外字段                                         **/

    /**
     * 已分配总数
     */
    @TableField(exist = false)
    private String yfpgs;
    /**
     * 已锁定总数
     */
    @TableField(exist = false)
    private String ysdzs;
    /**
     * 标记
     */
    @TableField(exist = false)
    private String flag;

    /**
     * 主键ID数组
     */
    @TableField(exist = false)
    private String[] zfhdxxIdS;
    @Override
    public String getId() {
        return zfhdxxId;
    }

    @Override
    public void setId(String id) {
        this.zfhdxxId = id;
    }


}
