package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zfryqd.wdpx.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zfryqd.wdks.entity.KsCxVO;

import java.util.List;
import java.util.Map;

/****
 * @className NdxfcxService
 * @author hufanghua
 * @description 年度学分查询Service接口层接口
 * @version 1.0
 * @date 2020-05-28 15:03
 */
public interface NdxfcxService {
    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @return
     */
     Page<KsCxVO> page(Page<KsCxVO> page, KsCxVO entity);

    /**
     * 查询年度集合
     * @author LSH
     * @return
     */
    List<String> queryNdList();

    /**
     * 分页查询执法人员某年度在线学习列表
     * @param page
     * @param mp
     * @return
     */
    Page<Map<String,Object>> queryKcxxByNdList(Page<Map<String,Object>> page, Map<String,Object> mp);

    /**
     * 分页查询执法人员某年度培训信息列表
     * @param page
     * @param mp
     * @return
     */
    Page<Map<String,Object>> queryPxxxByNdList(Page<Map<String,Object>> page, Map<String,Object> mp);

    /**
     * 分页查询执法人员某年度外部培训信息列表
     * @param page
     * @param mp
     * @return
     */
    Page<Map<String,Object>> queryWbpxByNdList(Page<Map<String,Object>> page, Map<String,Object> mp);

    /**
     * 分页查询执法人员某年度考试信息列表
     * @param page
     * @param mp
     * @return
     */
    Page<Map<String,Object>> queryKsxxByNdList(Page<Map<String,Object>> page, Map<String,Object> mp);

    /**
     * 查询年度学分记录
     * @param zfryxxId 执法人员信息id
     * @param nd 年度
     * @return
     */
    Map<String,Object> queryZxfByNd(String zfryxxId, String nd);
}