package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zfryqd.wdpx.entity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;
import java.util.Date;

/****
 * @className SfsbVO
 * @author User
 * @description 学分申报实体类
 * @version 1.0
 * @date 2020-05-15 11:17
 */
@Data
@TableName("ZFPXGL_J_XFSBXX")
public class XfsbVO extends BaseEntity<String> {

    /**
     * 学分申报信息id
     */
    @TableId("XFSBXX_ID")
    private String xfsbxxid;

    /**
     * 执法人员信息id
     */
    private String zfryxxid;

    /**
     * 姓名
     */
    private String xm;

    /**
     * 执法证号
     */
    private String zfzh;

    /**
     * 组织机构id
     */
    private String zzjgid;

    /**
     * 所属机构
     */
    private String ssjg;

    /**
     * 审核人
     */
    @TableField(exist = false)
    private String shr;

    /**
     * 培训类型代码
     */
    private String pxlxdm;

    /**
     * 培训名称
     */
    private String pxmc;

    /**
     * 培训描述
     */
    private String pxms;

    /**
     * 开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date kssj;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date jssj;

    /**
     * 培训证书名称
     */
    private String pxzsmc;

    /**
     * 培训机构名称
     */
    private String pxjgmc;

    /**
     * 总学时
     */
    private String zxs;

    /**
     * 总学分
     */
    private String zxf;

    /**
     * 总课时
     */
    private String zks;

    /**
     * 申报日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date sbrq;

    /**
     * 审核日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date shrq;

    /**
     * 申报状态
     * '0' 待审核   ‘1’审核通过   ‘2’不通过   ‘3’已发布
     */
    private String sbzt;

    /**
     * 申报状态名称
     */
    @TableField(exist = false)
    private String sbztmc;


    @Override
    public String getId() {
        return xfsbxxid;
    }

    @Override
    public void setId(String id) {
        this.xfsbxxid = id;
    }
}
