package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zfryqd.wdks.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.common.entity.TkTreeVo;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zfryqd.wdks.entity.*;

import java.util.List;

/**
 * @author hy
 * @create 2020-07-04
 */
public interface ZxKsService {
    /**
     * 在线测试查询左侧列表
     * @return
     */
    List<ZxKsUtilVO> queryZxKsLeft(ZxKsVO zxKsVO);
    List<ZxKsUtilVO> queryZxKsLeftByApp(ZxKsVO zxKsVO);

    /**
     * 校验输入的题目数量是否符合要求
     * @param zxKsVO
     * @return
     */
    List<ZxKsVO> checkStnum(ZxKsVO zxKsVO);

    /**
     * 根据用户获取在线测试题库数量
     * @param appTmNumVo
     * @return
     */
    List<AppTmNumVo> getZxcsStNum(AppTmNumVo appTmNumVo);
    /**在线测试
     * 查询执法门类和题库
     * @return
     */
    ZfMlAndStUtilVO queryZfMlAndTk(SysUser sysUser);

    /**
     * 查询在线测试右侧试题内容
     * @param stId
     * @param flag
     * @param zcjlId
     * @param sjId
     * @return
     */
    ZxKsStInfoUtilVO queryZxKsStInfo(String stId,String flag,String zcjlId,String sjId);

    /**
     * app的查询右侧试题内容
     * @param stId
     * @param flag
     * @param zcjlId
     * @return
     */
    ZxKsStInfoUtilVO queryZxKsStInfoByApp(String stId,String flag,String zcjlId);

    /**
     * 在线测试提交答案
     * @param zxCsData
     */
    List<ZxCsReturnDataVO> submitZxCsData(String zxCsData, SysUser sysUser);
    /**
     * app在线测试提交答案
     * @param zxCsData
     */
    List<ZxCsReturnDataVO> submitZxCsDataByApp(String zxCsData, SysUser sysUser);

    /**
     * 保存主观题分数
     * @param zgtdfData
     */
    void saveDf(String zgtdfData,SysUser sysUser);

    /**
     * 自测记录查询
     * @param zcJlVO
     * @param current
     * @param size
     * @return
     */
    Page<ZcJlVO> queryZcHistory(ZcJlVO zcJlVO, long current, long size);

    /**
     * 自测查询具体明细
     * @param zcjlI
     * @return
     */
    List<ZxCsReturnDataVO> queryZjLsMx(String zcjlI);

    /**
     * 查询执法门类和题库ID
     * @param sjId
     */
    ZxKsVO queryZfmlAndTkId( String sjId);

    /**
     * 查询自测题库范围
     * @param zcjlId
     * @return
     */
    TkTreeVo queryZcTkFw(String zcjlId);
}
