package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zfryqd.wdks.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.entity.StJcTxVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zfryqd.wdks.entity.SjstglVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zfryqd.wdks.entity.TkTestVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zfryqd.wdks.entity.ZfRyStGlVO;

import java.util.List;

/**
 * <p>
 * 执法人员试题练习信息
 * 只有加入错题本和答题正确的题目录入，答错但是没有加入错题本的不录入 服务类
 * </p>
 *
 * @author 黄宇
 * @since 2020-07-02
 */
public interface ZfryStGlService {
    /**
     * 插入错题标记本
     *
     * @param zfRyStGlVO
     * @return
     */
    boolean insertCtb(ZfRyStGlVO zfRyStGlVO, SysUser sysUser);

    /**
     * 新增试题纠错提醒
     *
     * @param stJcTxVO
     * @param curUser
     * @return
     */
    boolean insertJcTxInfo(StJcTxVO stJcTxVO, SysUser curUser);

    /**
     * 取消标记
     *
     * @param zfRyStGlVO
     * @param curUser
     * @return
     */
    boolean deleteCtBj(ZfRyStGlVO zfRyStGlVO, SysUser curUser);

    /**
     * 根据提醒人ID查询试题纠错
     *
     * @param zfryxxId
     * @return
     */
    List<StJcTxVO> queryStTxById(String zfryxxId, String stId);

    /**
     * 查询错题本或者标记本
     *
     * @return
     */
    List<SjstglVO> queryCtbOrBjb(SjstglVO sjstglVO);

    /**
     * 将试题移除错题本或者标记本
     *
     * @param vo
     * @return
     */
    boolean removeCtOrBjSt(ZfRyStGlVO vo, SysUser sysUser);

    /**
     * 查询试题题型
     *
     * @return
     */
    List<ZfRyStGlVO> querySttx(ZfRyStGlVO vo);

    /**
     * 查询试题是否标记过
     *
     * @param vo
     * @return
     */
    ZfRyStGlVO querySfBj(ZfRyStGlVO vo);

    /**
     * 纠错提醒分页
     *
     * @param page
     * @param zfryxxId
     * @param stId
     * @return
     */
    Page<StJcTxVO> queryStTxByIdPage(Page page, String zfryxxId, String stId);

    /******
     * 获取执法人员试题管理信息
     * @param zfryId 执法人员Id
     * @param stId 试题Id
     * @return
     */
    ZfRyStGlVO getEntityInfoByZfryIdAndStId(String zfryId, String stId);

    /****
     *
     * @param sysUser
     * @return
     */
    String queryOrgId(SysUser sysUser);

    /******
     * 题库练习查询右侧题库信息
     * @param zfmldm 执法门类代码
     * @param tkmc 题库名称
     * @param orgId 组织机构Id
     * @param page 分页信息
     * @return
     */
    List<TkTestVO> queryTkInfo(String zfmldm, String tkmc, String orgId, Page<TkTestVO> page);

    /******
     * 新增执法人员试题管理信息
     * @param entity 实体类信息
     * @return
     */
    int insertEntityInfoByEntity(ZfRyStGlVO entity);
}

