package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zfryqd.wdks.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.entity.StVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zfryqd.wdks.entity.TkTestVO;

import java.util.List;

/**
 * 题库练习的接口层
 *
 * @author hy
 * @create 2020-07-06
 */
public interface TkTestService {
    /**
     * 题库练习左侧执法门类的查询
     *
     * @return
     */
    List<TkTestVO> queryZfml();

    /**
     * 题库练习查询右侧题库信息
     *
     * @param zfmldm
     * @param tkmc
     * @return
     */
    Page<TkTestVO> queryTkInfo(String zfmldm, String tkmc, SysUser sysUser, long current, long size);

    /**
     * 根据试题ID查询试题题型以及数量
     *
     * @param stId
     * @return
     */
    List<TkTestVO> queryStTxDm(String stId, SysUser sysUser);

    /**
     * 查询题库练习中的试题信息 参数 题库ID 执法门类代码
     *
     * @param vo
     * @return
     */
    List<TkTestVO> queryTkTestStInfo(TkTestVO vo);

    /**
     * 将试题状态改成未通关
     *
     * @param kstkId
     * @return
     */
    boolean updateCxks(String kstkId, SysUser sysUser);

    /*****
     * 题库练习确认答案
     * @param entity
     * @param curUser
     * @return
     */
    StVO submitDa(TkTestVO entity, SysUser curUser);
}
