package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zfryqd.wdks.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.common.entity.FjVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.common.entity.SjUtilVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.common.entity.TkTreeVo;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.entity.KsXxVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zfryqd.wdks.entity.KaoShiInfoVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zfryqd.wdks.entity.KsCxVO;

import java.util.List;


public interface KscxService {

    /******
     * 考试查询分页查询
     * @param page  分页试题对象
     * @param entity  分页对象
     * @return
     */
    Page<KsCxVO> page(Page<KsCxVO> page, KsCxVO entity);

    /**
     * 查询考试的题库范围
     *
     * @param entity
     * @return
     */
    TkTreeVo queryTkFw(KsCxVO entity, SysUser sysUser);

    /**
     * 考试自测查询左侧列表
     *
     * @param sjId
     */
    List<KaoShiInfoVO> queryZcSt(String sjId);

    /**
     * 模拟练习查询题型和数量的列表
     *
     * @param sjId
     */
    List<KaoShiInfoVO> queryZcStByApp(String sjId);

    /**
     * 自测提交答案
     *
     * @param submitData
     */
    List<KaoShiInfoVO> submitZcResult(String submitData, String sjId, SysUser sysUser);

    List<KaoShiInfoVO> submitZcResultByApp(String submitData, String sjId, SysUser sysUser, String ksxxid);


    /**
     * 根据考试代码加入考试
     *
     * @param jrdm
     * @return
     */
    KsXxVO jrTest(String jrdm, SysUser sysUser);

    /**
     * 判断是否参加过考试
     *
     * @param ksxxId
     * @param curUser
     * @return
     */
    Integer checkSfAlreadyKs(String ksxxId, SysUser curUser);

    /**
     * 查询试卷附件的信息
     *
     * @param fjId 附件Id
     * @return
     */
    FjVO queryKsFjInfo(String fjId);

    /**
     * 线下考试试题与答案打印的方法
     *
     * @param sjId
     * @return
     */
    List<SjUtilVO> queryXxTestAnswer(String sjId);

}
