package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zfryqd.wdks.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 自测记录
 * </p>
 *
 * @author 黄宇
 * @since 2020-08-25
 */
@Data
@TableName("ZFKSGL_J_ZCJL")
public class ZcJlVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 自测记录的唯一标识
     */
    @TableId
    private String zcjlId;

    /**
     * 执法人员基本信息的唯一标识。
     */
    private String zfryxxId;

    /**
     * 测验时长，单位：分钟
     */
    private String cysc;

    /**
     * 实际使用时长，单位：秒
     */
    private String sjsysc;

    /**
     * 题库类型范围，多个逗号隔开
     */
    private String tklxfw;

    /**
     * 自测日期
     */
    private Date zcrq;

    /**
     * 总分
     */
    private Float zf;

    /**
     * 得分
     */
    private Float df;

    /**
     * 类型：1 模拟练习 2 在线自测
     */
    private String lx;

    /**            表外字段             **/

    /**
     * 自测时间 开始
     */
    @TableField(exist = false)
    private String  zcrqStart;
    /**
     * 自测时间 结束
     */
    @TableField(exist = false)
    private String  zcrqEnd;
    /**
     * 自测日期字符串
     */
    @TableField(exist = false)
    private String  zcrqStr;
    /**
     * 得分最大
     */
    @TableField(exist = false)
    private String  dfEnd;
    /**
     * 最小得分
     */
    @TableField(exist = false)
    private String  dfStart;

    @Override
    public String getId() {
        return zcjlId;
    }

    @Override
    public void setId(String id) {
        this.zcjlId = id;
    }


}
