package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zfryqd.wdks.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className SjVO
 * @author User
 * @description 试卷实体类
 * @version 1.0
 * @date 2020-05-26 19:32
 */
@Data
@TableName("ZFKSGL_J_SJ")
public class SjVO extends BaseEntity<String> {
    /**
     * 考试信息的唯一标识
     */
    @TableId("SJ_ID")
    private String sjid;

    /**
     * 考试信息的唯一标识
     */
    private String zjfsdm;

    /**
     * 试卷模板Id
     */
    private String sjmbid;

    /**
     * 版本号
     */
    private String bbh;

    /**
     * 名称
     */
    private String mc;

    /**
     * 总分
     */
    private String zf;

    /**
     * 时长
     */
    private String sc;

    /**
     * 试卷状态  ‘0’未报送  ‘1’待审核  ‘2’审核通过
     */
    private String zt;

    /**
     * 简介
     */
    private String jj;

    /**
     * 执法门类代码，多个以逗号隔开
     */
    private String zfml;

    /**
     * 试题数量
     */
    @TableField(exist = false)
    private String stsl;

    /**
     * 试题总分
     */
    @TableField(exist = false)
    private String stzf;

    /**
     * 节段标题
     */
    @TableField(exist = false)
    private String jdbt;

    /**
     * 试题题型代码
     */
    @TableField(exist = false)
    private String sttxdm;

    /**
     * 下发日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date xfrq;

    /**
     * 审核意见
     */
    private String shyj;

    /**
     * 使用用途  1 日常  2  评议考核
     */
    private String syyt;



    @Override
    public String getId() {
        return this.sjid;
    }

    @Override
    public void setId(String id) {
        this.sjid = id;
    }
}
