package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zfryqd.wdks.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysOrg;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.entity.KsJgGl;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.ksgl.entity.KsRyGlVO;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 考试信息
 * </p>
 *
 * @author pt
 * @since 2020-04-02
 */
@Data
@TableName("ZFKSGL_J_KSXX")
public class KsCxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 考试信息的唯一标识
     */
    @TableId("KSXX_ID")
    private String ksxxid;

    /**
     * 试卷的唯一标识
     */
    private String sjid;

    @TableField(exist = false)
    private String sftg;

    /**
     * 组织机构ID
     */
    private String zzjgid;

    /**
     * 是否合格
     */
    private String sfhg;

    /**
     * 考试类型代码
     */
    private String kslxdm;

    /**
     * 考试类型代码
     */
    private String kslx;

    /**
     * 考试科目代码
     */
    private String kskmdm;

    /**
     * 培训批次信息的唯一标识
     */
    private String pxpcxxId;

    /**
     * 考试名称
     */
    private String ksmc;

    /**
     * 简介
     */
    private String jj;

    /**
     * 考试开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date kskssj;

    /**
     * 考试结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date ksjssj;

    /**
     * 考试时长（单位：分钟）
     */
    private Integer kssc;

    /**
     * 合格分数
     */
    private Integer hgfs;

    /**
     * 是否有培训
     */
    private String sfypx;

    /**
     * 0 暂存 1 提交
     */
    private String zt;

    /**
     * 考试方式 0 线下 1 线上
     */
    private String ksfs;
    @TableField(exist = false)
    private String ksfsdm;

    /**
     * 考试方式 0 线下 1 线上
     */
    private String ksfsmc;

    /**
     * 考试方式 0 线下 1 线上
     */
    @TableField(exist = false)
    private String sbzt;

    /**
     * 人员添加方式
     */
    private String rytjfs;
    /**
     * 学分
     */
    private Integer xf;
    /**
     * 加入代码
     */
    private String jrdm;

    /***                             表外字段                                           ***/



    /**
     * 0 暂存 1 提交
     */
    @TableField(exist = false)
    private String kszt;
    /**
     * 考试信息的唯一标识
     */
    @TableField(exist = false)
    private String[] ksxxIds;

    /**
     * 考试结果
     */
    private String ksjg;

    /**
     * 考试成绩
     */
    @TableField(exist = false)
    private String kscj;



    /**
     * 是否已经考试  0 全部 1 未完成 2 已完成
     */

    private String isStartKs;

    /**
     * 试卷附件id
     */
    @TableField(exist = false)
    private String sjfjid;

    /**
     * 合格分数字符串
     */
    @TableField(exist = false)
    private  String hgfsStr;


    /**
     * 学分字符串
     */
    @TableField(exist = false)
    private  String xfStr;

    /**
     * 参考机构数据 {"ckjg":[{"zzjgid":"111","ncqrs":"2","ycqrs":"2"}]}
     */
    @TableField(exist = false)
    private String jgInfo;


    /**
     * 参考人员信息ID
     */
    @TableField(exist = false)
    private String[] zfryxxIdS;

    /**
     * 考试类型字典值
     */
    @TableField(exist = false)
    private String kslxCode;

    /**
     * 组织机构ID
     */
    @TableField(exist = false)
    private String orgId;

    /**
     * 数量
     */
    @TableField(exist = false)
    private String num;

    /**
     * 参考机构信息
     */
    @TableField(exist = false)
    private List<KsJgGl> ksJgGlList;

    /**
     * 参考机构信息
     */
    @TableField(exist = false)
    private List<SysOrg> alreadyJgInfoList;

    /**
     * 参考机人员信息
     */
    @TableField(exist = false)
    private List<KsRyGlVO> ksRyGlVOList;

    /***
     * 删除的组织机构ID
     */
    @TableField(exist = false)
    private String[] deleteOrgId;

    /***
     * 删除的参考机构ID
     */
    @TableField(exist = false)
    private String[] deleteZfryxxIdS;

    /**
     * 执法人员基本信息的唯一标识。
     */
    @TableField(exist = false)
    private String zfryxxId;

    /**
     * 执法人员的姓名。
     */
    @TableField(exist = false)
    private String xm;

    /**
     * 执法人员执法门类的代码。
     */
    @TableField(exist = false)
    private String zfmldm;

    /**
     * 人员的性别代码。
     */
    @TableField(exist = false)
    private String xbdm;

    /**
     * 执法人员人员的身份证号码。
     */
    @TableField(exist = false)
    private String sfzjhm;

    /**
     * 执法证号
     */
    @TableField(exist = false)
    private String zfzh;

    /**
     * 执法机构名称
     */
    @TableField(exist = false)
    private String zfjgmc;
    /**
     *
     */
    @TableField(exist = false)
    private String orgName;

    /**
     *试卷信息
     */
    @TableField(exist = false)
    private SjstglVO sjstglVO;

    /**
     * 试题内容
     */
    @TableField(exist = false)
    private List<String>nr;
    /**
     * 考试类型字典值
     */
    @TableField(exist = false)
    private String kslxdmCode;
    /**
     * 试卷模板id
     */
    @TableField(exist = false)
    private String sjmbId;
    /**
     * 版本号
     */
    @TableField(exist = false)
    private String bbh;
    /**
     * 标记
     */
    @TableField(exist = false)
    private String bj;
    @TableField(exist = false)
    private Long fenzhong;
    /**
     * 所获学分
     */
    @TableField(exist = false)
    private Float  shxf;

    /*****
     * 用户已参加考试
     */
    @TableField(exist = false)
    private boolean yhycjks;

    @Override
    public String getId() {
        return ksxxid;
    }

    @Override
    public void setId(String id) {
        this.ksxxid = id;
    }


    public String getIsStartKs() {
        return isStartKs;
    }

    public void setIsStartKs(String isStartKs) {
        this.isStartKs = isStartKs;
    }

}
