package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zfryqd.wdda.service;

import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.common.entity.GrSyBjQkVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.common.entity.GrSyDkSVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zfryqd.wdda.entity.GrBaseInfoVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zfryqd.wdda.entity.GrRankingVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zfryqd.wdda.entity.GrXfReturnVO;

import java.util.List;

/**
 * 个人首页服务
 */
public interface GrInfoShouYeService {
    /**
     * 个人首页查询基本信息
     * @param curUser
     */
    GrBaseInfoVO queryGrBaseInfo(SysUser curUser);

    /**
     * 个人首页查询学分信息
     * @param curUser
     */
    GrXfReturnVO queryGrXfInfo(SysUser curUser);

    /**
     * 个人首页年度查询 只查询有数据
     * @return
     */
    List<ComboboxVo> queryNd(SysUser sysUser);

    /**
     * 首页查询排名信息
     * @param nd
     * @param type
     * @param curUser
     */
    GrRankingVO queryRankingToZfRy(String nd, String type, SysUser curUser);

    /**
     * 个人首页点击全省排名 弹框
     * @param nd
     * @param curUser
     */
    GrRankingVO queryRankingLb(String lx,String nd,String type, SysUser curUser);

    /**
     * app点击全省排名 弹框
     * @param
     * @param curUser
     */
    List<GrRankingVO> queryRankingLbByApp( SysUser curUser,String xsxf,String dwqs);
    /**
     * app当前用户点击全省排名 弹框
     * @param
     * @param curUser
     */
    List<GrRankingVO> queryRankingLbByZfryxxid( SysUser curUser,String xsxf,String dwqs);

    /**
     * 个人首页查询 待考试数量
     * @param curUser
     */
    GrSyDkSVO queryGrDkSInfo(SysUser curUser);

    /**
     * 个人首页查询办件情况
     * @param sj
     * @param curUser
     */
    GrSyBjQkVO queryBjQkInfo(String sj, SysUser curUser);
}
