package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.KhbzXmGlVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.ZfryglJKhbzVO;

import java.util.List;


/**
 * <p>
 * 考核标准 服务类
 * </p>
 *
 * @author lixianrui
 * @since 2020-04-21
 */
public interface ZfryglJKhbzService {
    /**
     * 新增考核标准信息
     *
     * @param ZfryglJKhbzVO
     * @return
     */
    boolean insert(ZfryglJKhbzVO ZfryglJKhbzVO);

    /**
     * 新增考核标准 项目关联
     *
     * @param khbzXmGlVO
     * @return
     */
    boolean insertGl(KhbzXmGlVO khbzXmGlVO);

    /**
     * 修改考核标准信息
     *
     * @param ZfryglJKhbzVO
     * @return
     */
    boolean updateById(ZfryglJKhbzVO ZfryglJKhbzVO);

    /**
     * 启用时获取核标准信息有无新版本在启用
     *
     * @param ZfryglJKhbzVO
     * @return
     */
    boolean selectNewBbhById(ZfryglJKhbzVO ZfryglJKhbzVO);

    /**
     * 删除考核项目关联
     *
     * @param khbzId
     * @return
     */
    int deletekhxmGl(String khbzId);

    /**
     * 根据ID删除考核标准信息
     *
     * @param id 　考核标准ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取考核标准信息
     *
     * @param id
     * @return
     */
    ZfryglJKhbzVO getById(String id, String bbh);

    /**
     * 根据ID获取考核标准关联信息
     *
     * @param id
     * @return
     */
    List<KhbzXmGlVO> getkhxmById(String id, String bbh);


    /**
     * 分页查询
     *
     * @param current       当前页
     * @param size          每页显示条数
     * @param ZfryglJKhbzVO
     * @return
     */
    Page<ZfryglJKhbzVO> page(long current, long size, ZfryglJKhbzVO ZfryglJKhbzVO);

    /**
     * 定时任务更新启用
     *
     * @param zfryglJKhbzVO
     * @return
     */
    boolean updateKhbzZt(ZfryglJKhbzVO zfryglJKhbzVO);

    /**
     * 根据当前机构id 查询上级id
     *
     * @param orgid
     * @return
     */
    String selectOrgPid(String orgid);

    /**
     * 获取当前标准id的最大版本号（复制需要）
     *
     * @return
     */
    String getMaxBbh(String khbzId);

    /**
     * 操作关联考核项目表
     *
     * @param khxmIdArr
     * @param zfryglJKhbzVO
     * @return
     */
    void updateGl(String[] khxmIdArr, ZfryglJKhbzVO zfryglJKhbzVO, SysUser curUser);
}
