package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.common.component.TreeDataVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysOrg;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.common.entity.FjVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.*;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zjgl.entity.ZfHxXVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zjgl.entity.ZfZjXxVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.zjgl.entity.ZjLsJlVO;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 执法人员信息 服务类
 * </p>
 *
 * @author 黄宇
 * @since 2020-03-18
 */
public interface ZfRyXxService {

    /**
     * 新增执法人员信息信息
     *
     * @param zfRyXxVO
     * @return
     */
    boolean insert(ZfRyXxVO zfRyXxVO, SysUser sysUser);

    /**
     * 查询执法人员基本信息根据执法人员Id
     *
     * @param zfryId
     * @return
     */
    ZfRyXxVO queryZfryBaseInfoByZfryId(String zfryId);

    /**
     * 修改执法人员信息信息
     *
     * @param zfRyXxVO
     * @return
     */
    boolean updateById(ZfRyXxVO zfRyXxVO, SysUser sysUser);

    /**
     * 根据ID删除执法人员信息信息
     *
     * @param id 　执法人员信息ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取执法人员信息信息
     *
     * @param zfryxxId
     * @return
     */
    ZfRyXxVO getById(String zfryxxId);

    /**
     * 根据ID数组获取信息
     *
     * @param zfryxxIdArr
     * @return
     */

    List<ZfRyXxVO> getByIdS(String[] zfryxxIdArr);

    /**
     * 分页查询
     *
     * @param current  当前页
     * @param size     每页显示条数
     * @param zfRyXxVO
     * @return
     */
    Page<ZfRyXxVO> page(long current, long size, ZfRyXxVO zfRyXxVO);

    /**
     * 保存附件
     *
     * @param fjVO
     */
    void saveFileInfo(FjVO fjVO);

    /**
     * 删除附件
     *
     * @param fjVO
     * @return
     */
    boolean fileDeleteByIds(FjVO fjVO);

    /**
     * 更新附件
     *
     * @param zfryglJZfryxx
     * @return
     */
    int updateFj(ZfRyXxVO zfryglJZfryxx);

    /**
     * 查询附件
     *
     * @param zfryxxId
     * @return
     */
    List<FjVO> getFjLj(String zfryxxId);

    /**
     * 查询上级机构
     *
     * @param orgId
     * @return
     */
    List<TreeDataVo> getSjOrgTree(String orgId);

    /**
     * 申请准入和审批
     *
     * @param zfRyXxVO
     * @param rySpbVO
     * @param spbZfryGlVO
     * @return
     */
    int updateRySPxX(ZfRyXxVO zfRyXxVO, RySpbVO rySpbVO, SpbZfryGlVO spbZfryGlVO);

    /**
     * 根据flag去更新人员状态
     *
     * @param zfRyXxVO
     * @return
     */
    int updateZTByFlag(ZfRyXxVO zfRyXxVO, RybdxxVO rybdxxVO);

    /***
     * 根据勾选信息导出
     * @param zfRyXxVO
     * @return
     */
    List<ZfRyXxVO> daochuToZfRyXx(ZfRyXxVO zfRyXxVO);

    /**
     * 根据查询条件导出
     *
     * @param zfRyXxVO
     * @return
     */
    List<ZfRyXxVO> daochuToZfRyXxByQuery(ZfRyXxVO zfRyXxVO);

    /**
     * 退休进行表操作
     *
     * @param vo
     * @param zjLsJlVO
     * @param zfZjXxVO
     * @param hxXVO
     * @return
     */
    Boolean updateXX(ZfRyXxVO vo, ZjLsJlVO zjLsJlVO, ZfZjXxVO zfZjXxVO, ZfHxXVO hxXVO, RybdxxVO rybdxxVO);

    /**
     * 查询执法人员最新的执法证件信息
     *
     * @param zfZjXxVO
     * @return
     */
    ZfZjXxVO queryZfZjInfo(ZfZjXxVO zfZjXxVO);

    /**
     * 批量删除
     *
     * @param zfRyXxVO
     * @return
     */
    Boolean deleteRyxx(ZfRyXxVO zfRyXxVO, SysUser sysUser);


    /**
     * 查询单位名称以及级别
     *
     * @param spjg
     * @return
     */
    SysOrg getOrgInfoByOrgId(String spjg);

    /**
     * 查询证件颁发列表信息
     *
     * @param current
     * @param size
     * @param zfRyXxVO
     * @return
     */
    Page<ZfRyXxVO> searchZjBfInfo(long current, long size, ZfRyXxVO zfRyXxVO);

    /**
     * 根据执法证号查询执法人员信息
     *
     * @param zfzh
     * @return
     */
    ZfRyXxVO queryZfRyInfoByZfZh(String zfzh);

    /**
     * 根据主键查询人员信息分页
     *
     * @param current
     * @param size
     * @param zfRyXxVO
     * @return
     */
    Page<ZfRyXxVO> getRyInfoByIdS(long current, long size, ZfRyXxVO zfRyXxVO);

    /**
     * 分析研判系统数据对接接口
     *
     * @param zfRyDataVO
     * @param current
     * @param size
     * @return
     */
    Page<ZfRyDataVO> queryZfRyInfoList(long current, long size, ZfRyDataVO zfRyDataVO);

    /**
     * 指挥调度系统 执法人员查询接口 addtime 2020-12-22 杨前海修改（本来是上面一个接口）--单独拿出组织机构作为另外一个条件
     *
     * @param current       分页参数
     * @param size          分页参数
     * @param zfRyDataVO    查询参数对象
     * @param orgParameters 单独的组织机构id
     * @return
     */
    Page<ZfRyDataVO> queryZfRyInfoListForZhdd(long current, long size, ZfRyDataVO zfRyDataVO, String orgParameters);

    /**
     * 分析研判系统数据对接接口--根据执法证号查询人员详细信息
     *
     * @param zfryId
     * @return
     */
    ZfRyDataVO queryZfryByZfRyXxId(String zfryId);

    /**
     * 查询审批的附件
     *
     * @param spbZfryGlVO
     */
    ZfRyXxVO querySpInfoFj(SpbZfryGlVO spbZfryGlVO);

    /**
     * 根据组织机构Id查询人员信息
     *
     * @param orgId
     * @return
     */
    List<ZfRyXxVO> queryZfRyInfoByOrgId(String orgId);

    /**
     * 培训批次管理--选择人员
     *
     * @param current
     * @param zfRyXxVO
     * @return
     */
    Page<ZfRyXxVO> pageListRy(long current, long size, ZfRyXxVO zfRyXxVO);

    /**
     * 查看人员的审批流程信息
     *
     * @param zfryxxId
     * @return
     */
    SpLcMxVO querySpLcMxInfo(String zfryxxId);

    /**
     * excel表格导入人员信息
     *
     * @param zfRyXxVOList
     * @param curUser
     * @return
     */
    ZfRyXxVO insertZfRyInfo(List<ZfRyXxVO> zfRyXxVOList, SysUser curUser);

    /**
     * excel 插入人员附加信息
     *
     * @param ryJyXxVOS
     * @param ryPxXxVOS
     * @param ryKsXxVOS
     * @param ryJlXxVOS
     * @param ryCfXxVOS
     * @return
     */
    ZfRyXxVO insertZfRyFjInfo(List<RyJyXxVO> ryJyXxVOS, List<RyPxXxVO> ryPxXxVOS, List<RyKsXxVO> ryKsXxVOS, List<RyJlXxVO> ryJlXxVOS, List<RyCfXxVO> ryCfXxVOS);

    /**
     * 根据组织机构名称查询组织机构ID
     *
     * @param orgName
     * @return
     */
    String queryOrgIdByOrgName(String orgName);

    /**
     * 根据身份证号和姓名获取执法人员信息信息
     *
     * @param sfzjhm
     * @return
     */
    ZfRyXxVO getBysfzj(String sfzjhm, String xm);

    /**
     * 查询父节点ID
     *
     * @param orgId
     * @return
     */
    String getPorgId(String orgId);

    /**
     * 指挥调度系统的查询接口 -- 根据组织机构ID查询
     *
     * @param zfryxxIdArr
     * @return
     */
    List<ZfRyDataVO> queryZfryInfoByOrgIdArr(String[] zfryxxIdArr, String orgId);

    /**
     * 根据身份证号查询是否存在这个执法人员信息
     *
     * @param sfzjhm
     * @return
     */
    boolean queryZfRyInfoBySfZjHm(String sfzjhm);

    /**
     * 人员退休处理
     *
     * @param zfRyXxVOList
     * @return
     */
    boolean tuiXiuApply(List<ZfRyXxVO> zfRyXxVOList, SysUser sysUser, String idCards);

    /**
     * 人员调离处理
     *
     * @param zfRyXxVOList
     * @param curUser
     * @return
     */
    boolean diaoLiInfo(List<ZfRyXxVO> zfRyXxVOList, SysUser curUser, String idCards);

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户所属组织机构Id
     * @return
     */
    Page<ZfRyXxVO> pageData(Page<ZfRyXxVO> page, ZfRyXxVO entity, String curUserOrgId);

    /**
     * 执法证号的执法机构树
     *
     * @param orgId
     * @return
     */
    List<TreeDataVo> queryOrgTreeData(String orgId);

    /**
     * 判断身份证号是否存在
     *
     * @param sfzjhm   身份证号码
     * @param zfryxxId 执法人员信息id
     * @return
     */
    Map<String, Integer> queryZfRyBySfZjHm(String sfzjhm, String zfryxxId, String lxdh);

    /**
     * 查询审批机构树
     *
     * @param sysUser
     * @return
     */
    TreeDataVo querySpJgTree(SysUser sysUser);

    /*****
     * 获取执法人员信息
     * @param filter 关键字(执法证号或者身份证号)
     * @param curUserOrgId 当前用户组织机构Id
     * @return
     */
    ZfRyXxVO getEntityInfoByFilterAndOrgId(String filter, String curUserOrgId);

    /**
     * 高速路政支队人员数据录入
     *
     * @param zfRyXxVOList
     * @return
     */
    boolean updateGsDdInfo(List<ZfRyXxVO> zfRyXxVOList);

    /**
     * 查询吊销集合
     *
     * @param page
     * @param mp
     * @return
     */
    Page<Map<String, Object>> queryRevokeList(Page<Map<String, Object>> page, Map<String, Object> mp);

    /**
     * 查询吊销详情
     *
     * @return
     */
    ZjLsJlVO queryRevokeDetail(String zfryxxId);

    /**
     * 装备系统 查询执法人员的姓名
     *
     * @param orgId
     * @return
     */
    List<ComboboxVo> queryZfryXmByCurrentOrgId(String orgId);

    /**
     * 根据名称获取执法人员信息信息 -- 执法装备接口
     *
     * @param zfryxm
     * @return
     */
    public ZfRyXxVO queryZfryInfoByZfryxm(String zfryxm);

    /**
     * 统计执法人员
     *
     * @param zfRyXxVO
     */
    ZfRyTjVO tJZfryInfo(ZfRyXxVO zfRyXxVO);

    /**
     * 执法人员统计分页查询
     *
     * @param utilVO
     * @param current
     * @param size
     * @return
     */
    Page<TjZfryUtilVO> queryZfryTjPage(TjZfryUtilVO utilVO, long current, long size);

    /**
     * 首页执法人员统计查询
     *
     * @param cxfw
     * @param sj
     * @param orgId
     * @return
     */
    SyZfRyTjVO queryTjZfry(String cxfw, String sj, String orgId);

    /**
     * 人员查询统计根据查询条件查询数据
     *
     * @param utilVO
     * @return
     */
    List<TjZfryUtilVO> daochuRyTjByQuery(TjZfryUtilVO utilVO);

    /**
     * 人员查询统计勾选导出
     *
     * @param utilVO
     * @return
     */
    List<TjZfryUtilVO> daochuRyTjByGouXuan(TjZfryUtilVO utilVO);

    /**
     * 查询执法人员的身份证号码
     *
     * @param zfryxxIdArr
     * @return
     */
    List<String> queryRySfZhM(String[] zfryxxIdArr);

    /**
     * 指挥调度查询执法人员列表
     *
     * @param page
     * @param zfRyXxVO
     * @return
     */
    List<ZfRyDataVO> queryZfRyInfoListForZhdd(Page<ZfRyDataVO> page, ZfRyXxVO zfRyXxVO);

    /******
     * 获取执法人员信息
     * @param filter 关键字过滤
     * @param orgId 组织机构Id
     * @param curUserOrgId 当前登录用户所属组织机构
     * @return
     */
    List<ComboboxVo> queryEntityInfoCombobox(String filter, String orgId, String curUserOrgId);

    /**
     * 指挥调度系统
     * 定时任务查询最近1小时更新的人员信息
     *
     * @return
     */
    List<ZfRyDataVO> queryRecentlyRyInfo();

    /**
     * 根据用户表的组织机构更新人员表的数据  不在系统功能内
     *
     * @param list
     * @return
     */
    List<ZfRyXxVO> updateZfRyOrgId(List<ZfRyXxVO> list, SysUser sysUser);

    void updateZfryInfoByDaoRu(ZfRyXxVO zfRyXxVO, SysUser sysUser);

    /**
     * 导入待执法证号的数据
     *
     * @param excelDaoRuData
     * @param curUser
     * @return
     */
    ZfRyXxVO handleZfRyIno(List<ZfRyXxVO> excelDaoRuData, SysUser curUser);

    /**
     * 校验导入数据中的联系电话
     *
     * @param sfzjhm
     * @param lxdh
     * @return
     */
    Integer checkDaoRuLxDh(String sfzjhm, String lxdh);

    /**
     * 查询岗位代码列表
     *
     * @return
     */
    List<Object> queryGwDjDm();

    /******
     * 获取执法人员信息
     * @param zfryId 执法人员Id
     * @return
     */
    ZfRyXxVO getEntityInfoByZfryId(String zfryId);

    /******
     * 获取执法人员信息
     * @param zfzh 执法证号
     * @return
     */
    ZfRyXxVO getEntityInfoByZfzh(String zfzh);

    /******
     * 重置执法人员信息
     * @param ids 执法人员Id集合
     * @param curUser 当前登录用户
     */
    void resetZfryInfo(String ids, SysUser curUser);

    /******
     * 修改执法人员执法证号
     * @param id  执法人员Id
     * @param zfzh 执法证号
     * @param curUser 当前登录用户
     */
    void modifyZfzh(String id, String zfzh, SysUser curUser);

    /*****
     * 获取所有的执法人员信息
     * @return
     */
    List<ZfRyXxVO> queryAllZfryInfo();
}

