package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.ExportDataModel;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.RybdxxVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.ZfRyXxVO;

import java.util.List;


/**
 * <p>
 * 人员变动信息 服务类
 * </p>
 *
 * @author pt
 * @since 2020-03-20
 */
public interface RybdxxService {

    /**
     * 新增人员变动信息信息
     *
     * @param rybdxx
     * @return
     */
    boolean insert(RybdxxVO rybdxx);

    /**
     * 修改人员变动信息信息
     *
     * @param rybdxx
     * @return
     */
    boolean updateById(RybdxxVO rybdxx);

    /**
     * 根据ID删除人员变动信息信息
     *
     * @param id 　人员变动信息ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取人员变动信息信息
     *
     * @param id
     * @return
     */
    RybdxxVO getById(String id);


    /**
     * 分页查询--调入
     *
     * @param current 当前页
     * @param size    每页显示条数
     * @param rybdxx
     * @return
     */
    Page<RybdxxVO> page(long current, long size, RybdxxVO rybdxx);

    /**
     * 分页查询--调出
     *
     * @param current 当前页
     * @param size    每页显示条数
     * @param rybdxx
     * @return
     */
    Page<RybdxxVO> pagedc(long current, long size, RybdxxVO rybdxx);

    /**
     * 同意或拒绝调入
     *
     * @param rybdxx
     * @param zfRyXxVO
     * @param idArr
     * @param curUser
     * @return
     */
    boolean tyorjjdr(RybdxxVO rybdxx, ZfRyXxVO zfRyXxVO, String[] idArr, SysUser curUser );

    /**
     * 获取变动人员信息
     *
     * @param rybdxxId
     * @return
     */
    RybdxxVO getBdxxinfo(String rybdxxId);

    /**
     * 批量撤销变动
     *
     * @param rybdxxVO
     * @param rybdxxIdArr
     * @return
     */
    boolean updateByIdArr(RybdxxVO rybdxxVO, String[] rybdxxIdArr);

    /**
     * 查询导出信息
     *
     * @param rybdxxIdArr
     * @return
     */
    List<ExportDataModel> selectList(String[] rybdxxIdArr);

    /**
     * 获取变动人员信息（通过人员信息id）
     *
     * @param zfryxxId
     * @return
     */
    RybdxxVO getByryxxId(String zfryxxId);

    /**
     * 导入表格内容验证
     *
     * @param
     * @return
     */
    boolean importExcel(List<RybdxxVO> voList);
}