package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.RySpbVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.SpLcMxVO;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.rygl.entity.SpbZfryGlVO;


import java.util.List;

/**
 * <p>
 * 人员审批表 服务类
 * </p>
 *
 * @author 黄宇
 * @since 2020-03-20
 */
public interface RySpbService {

    /**
     * 人员审批列表查询分页
     * @param current
     * @param size
     * @param zfryglJRyspb
     * @return
     */
    Page<RySpbVO> getRySpPage(long current, long size, RySpbVO zfryglJRyspb,SysUser sysUser);

    /**
     *  查询审批信息
     * @param spbZfryGlVO
     * @return
     */
    List<SpbZfryGlVO> rysp(SpbZfryGlVO spbZfryGlVO);

    /**
     * 查询头部信息
     * @param ryspbId
     * @return
     */
    RySpbVO selectTopInfo(String ryspbId);

    /**
     * 查询单位审核信息
     * @param ryspbId
     * @return
     */
    RySpbVO selectShInfo(String ryspbId);

    /**
     * 获取人员审批信息
     * @param ryspbId
     * @return
     */
    RySpbVO getRyspXx(String ryspbId);

    /**
     * 人员审批信息操作
     * @param lcMxVOList
     * @param rySpbVOList
     * @return
     */
    void updateRySp(List<SpLcMxVO> lcMxVOList, List<RySpbVO> rySpbVOList, SysUser sysUser);

    /**
     * 查询人员的具体审批信息
     * @param rySpbVO
     * @return
     */
    SpLcMxVO queryRySpInfo(RySpbVO rySpbVO);

    /**
     * 查看人员审批信息
     * @param spbZfryGlVO
     * @return
     */
    List<SpbZfryGlVO> viewRySpInfo(SpbZfryGlVO spbZfryGlVO);

    /**
     * 根据主键ID查询人员审批表
     * @param ryspbId
     * @return
     */
    RySpbVO selectById(String ryspbId);

    /**
     * 查询机构信息通过orgcode
     * @param orgcode
     * @return
     */
    String queryJgInfoByOrgCode(String orgcode);

    /**
     * 查询审批的锁定状态
     * @param ryspbId
     * @return
     */
    RySpbVO querySdZt(String ryspbId);

    /**
     * 更新锁定状态
     * @param rySpbVO
     * @return
     */
    boolean updateSdZt(RySpbVO rySpbVO);

    /**
     * 刷新浏览器清空已锁定人员审批的数据
     * @param rySpbVO
     * @return
     */
    boolean refreshLlq(RySpbVO rySpbVO,String userId);
}

